export declare abstract class Storage {
    protected baseKey: string;
    constructor(baseKey?: string);
    has(name: string): boolean;
    /**
     * Returns a scoped key for storage.
     * @param key The storage key.
     *
     * @example Storage.key('hello') // 'salte.auth.handler.redirect.hello'
     */
    protected key(key?: string): string;
}
export interface Storage {
    get(name: string, defaultValue?: string): string | null;
    set(name: string, value: any): void;
    delete(name: string): void;
    clear(): void;
}
