import { Events } from './events';
export declare class Shared extends Events {
    constructor(config?: Shared.Config);
    /**
     * Returns a redirect url for the given login type.
     * @param type - Are we logging in or logging out?
     */
    redirectUrl(type: 'login' | 'logout'): string;
}
export interface Shared {
    config: Shared.Config;
}
export declare namespace Shared {
    interface Config extends Events.Config {
        [key: string]: any;
        /**
         * URL the Provider will send the response back to.
         */
        redirectUrl?: string | RedirectUrl;
    }
    interface RedirectUrl {
        /**
         * The URL the Provider will send the response back to on login.
         */
        login: string;
        /**
         * The URL the Provider will send the response back to on logout.
         */
        logout: string;
    }
}
