import { OAuth2Provider } from './provider-oauth2';
import { IDToken, Interceptors } from '../utils';
export declare class OpenIDProvider extends OAuth2Provider {
    idToken?: IDToken;
    constructor(config?: OpenIDProvider.Config);
    secure(request: Interceptors.XHR.ExtendedXMLHttpRequest | Request): Promise<'login' | boolean>;
    $validate(options: OpenIDProvider.Validation): void;
    validate(options: OpenIDProvider.Validation): void;
    $login(options?: OpenIDProvider.OverrideOptions): string;
    sync(): void;
}
export interface OpenIDProvider {
    config: OpenIDProvider.Config;
}
export declare namespace OpenIDProvider {
    interface Config extends OAuth2Provider.Config {
        /**
         * Determines whether a authorization code (server) or id token (client) should be returned.
         */
        responseType?: ('id_token' | 'id_token token' | 'code');
        validation?: boolean | ValidationOptions;
        /**
         * Determines whether token renewal should be handled automatically or manually.
         *
         * @defaultValue 'auto'
         */
        renewal?: ('auto' | 'manual' | {
            type?: ('auto' | 'manual');
            /**
             * The amount of time prior to experation to renew the `id_token`.
             *
             * @defaultValue 60000
             */
            buffer?: number;
        });
    }
    interface ValidationOptions extends OAuth2Provider.ValidationOptions {
        /**
         * Disables replay attack mitigation via "nonce".
         */
        nonce: boolean;
    }
    interface OverrideOptions extends OAuth2Provider.OverrideOptions {
        /**
         * Indicate that the Provider shouldn't display any user interaction.
         */
        prompt?: ('none' | 'login' | 'consent' | 'select_account');
    }
    interface Validation extends OAuth2Provider.Validation {
        /**
         * A JSON Web Token (JWT) that contains user profile information
         */
        id_token: string;
    }
}
