import { OAuth2Provider } from './base/provider-oauth2';
import { OpenIDProvider } from './base/provider-openid';
export declare class OAuth2 extends OAuth2Provider {
    constructor(config: OAuth2.Config);
    get name(): string;
    get login(): string;
}
export interface OAuth2 {
    config: OAuth2.Config;
}
export declare namespace OAuth2 {
    interface Config extends OAuth2Provider.Config {
        login(): string;
    }
}
export declare class OpenID extends OpenIDProvider {
    constructor(config: OpenID.Config);
    get name(): string;
    get login(): string;
    get logout(): string;
}
export interface OpenID {
    config: OpenID.Config;
}
export declare namespace OpenID {
    interface Config extends OpenIDProvider.Config {
        login(): string;
        logout(): string;
    }
}
