
/**
 * @salte-auth/salte-auth JavaScript Library v3.1.8
 *
 * @license MIT (https://github.com/salte-auth/salte-auth/blob/master/LICENSE)
 *
 * Made with ♥ by Ceci Woodward <ceci@salte.io>, Dave Woodward <dave@salte.io>
 */

(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
	typeof define === 'function' && define.amd ? define(['exports'], factory) :
	(global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory((global.salte = global.salte || {}, global.salte.auth = {})));
}(this, (function (exports) { 'use strict';

	function unwrapExports (x) {
		return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
	}

	function createCommonjsModule(fn, module) {
		return module = { exports: {} }, fn(module, module.exports), module.exports;
	}

	var asyncToGenerator = createCommonjsModule(function (module) {
	function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) {
	  try {
	    var info = gen[key](arg);
	    var value = info.value;
	  } catch (error) {
	    reject(error);
	    return;
	  }

	  if (info.done) {
	    resolve(value);
	  } else {
	    Promise.resolve(value).then(_next, _throw);
	  }
	}

	function _asyncToGenerator(fn) {
	  return function () {
	    var self = this,
	        args = arguments;
	    return new Promise(function (resolve, reject) {
	      var gen = fn.apply(self, args);

	      function _next(value) {
	        asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value);
	      }

	      function _throw(err) {
	        asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err);
	      }

	      _next(undefined);
	    });
	  };
	}

	module.exports = _asyncToGenerator;
	module.exports["default"] = module.exports, module.exports.__esModule = true;
	});

	var _asyncToGenerator = unwrapExports(asyncToGenerator);

	var classCallCheck = createCommonjsModule(function (module) {
	function _classCallCheck(instance, Constructor) {
	  if (!(instance instanceof Constructor)) {
	    throw new TypeError("Cannot call a class as a function");
	  }
	}

	module.exports = _classCallCheck;
	module.exports["default"] = module.exports, module.exports.__esModule = true;
	});

	var _classCallCheck = unwrapExports(classCallCheck);

	var createClass = createCommonjsModule(function (module) {
	function _defineProperties(target, props) {
	  for (var i = 0; i < props.length; i++) {
	    var descriptor = props[i];
	    descriptor.enumerable = descriptor.enumerable || false;
	    descriptor.configurable = true;
	    if ("value" in descriptor) descriptor.writable = true;
	    Object.defineProperty(target, descriptor.key, descriptor);
	  }
	}

	function _createClass(Constructor, protoProps, staticProps) {
	  if (protoProps) _defineProperties(Constructor.prototype, protoProps);
	  if (staticProps) _defineProperties(Constructor, staticProps);
	  return Constructor;
	}

	module.exports = _createClass;
	module.exports["default"] = module.exports, module.exports.__esModule = true;
	});

	var _createClass = unwrapExports(createClass);

	var assertThisInitialized = createCommonjsModule(function (module) {
	function _assertThisInitialized(self) {
	  if (self === void 0) {
	    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
	  }

	  return self;
	}

	module.exports = _assertThisInitialized;
	module.exports["default"] = module.exports, module.exports.__esModule = true;
	});

	var _assertThisInitialized = unwrapExports(assertThisInitialized);

	var setPrototypeOf = createCommonjsModule(function (module) {
	function _setPrototypeOf(o, p) {
	  module.exports = _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
	    o.__proto__ = p;
	    return o;
	  };

	  module.exports["default"] = module.exports, module.exports.__esModule = true;
	  return _setPrototypeOf(o, p);
	}

	module.exports = _setPrototypeOf;
	module.exports["default"] = module.exports, module.exports.__esModule = true;
	});

	unwrapExports(setPrototypeOf);

	var inherits = createCommonjsModule(function (module) {
	function _inherits(subClass, superClass) {
	  if (typeof superClass !== "function" && superClass !== null) {
	    throw new TypeError("Super expression must either be null or a function");
	  }

	  subClass.prototype = Object.create(superClass && superClass.prototype, {
	    constructor: {
	      value: subClass,
	      writable: true,
	      configurable: true
	    }
	  });
	  if (superClass) setPrototypeOf(subClass, superClass);
	}

	module.exports = _inherits;
	module.exports["default"] = module.exports, module.exports.__esModule = true;
	});

	var _inherits = unwrapExports(inherits);

	var _typeof_1 = createCommonjsModule(function (module) {
	function _typeof(obj) {
	  "@babel/helpers - typeof";

	  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
	    module.exports = _typeof = function _typeof(obj) {
	      return typeof obj;
	    };

	    module.exports["default"] = module.exports, module.exports.__esModule = true;
	  } else {
	    module.exports = _typeof = function _typeof(obj) {
	      return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
	    };

	    module.exports["default"] = module.exports, module.exports.__esModule = true;
	  }

	  return _typeof(obj);
	}

	module.exports = _typeof;
	module.exports["default"] = module.exports, module.exports.__esModule = true;
	});

	var _typeof = unwrapExports(_typeof_1);

	var possibleConstructorReturn = createCommonjsModule(function (module) {
	var _typeof = _typeof_1["default"];



	function _possibleConstructorReturn(self, call) {
	  if (call && (_typeof(call) === "object" || typeof call === "function")) {
	    return call;
	  }

	  return assertThisInitialized(self);
	}

	module.exports = _possibleConstructorReturn;
	module.exports["default"] = module.exports, module.exports.__esModule = true;
	});

	var _possibleConstructorReturn = unwrapExports(possibleConstructorReturn);

	var getPrototypeOf = createCommonjsModule(function (module) {
	function _getPrototypeOf(o) {
	  module.exports = _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
	    return o.__proto__ || Object.getPrototypeOf(o);
	  };
	  module.exports["default"] = module.exports, module.exports.__esModule = true;
	  return _getPrototypeOf(o);
	}

	module.exports = _getPrototypeOf;
	module.exports["default"] = module.exports, module.exports.__esModule = true;
	});

	var _getPrototypeOf = unwrapExports(getPrototypeOf);

	var defineProperty = createCommonjsModule(function (module) {
	function _defineProperty(obj, key, value) {
	  if (key in obj) {
	    Object.defineProperty(obj, key, {
	      value: value,
	      enumerable: true,
	      configurable: true,
	      writable: true
	    });
	  } else {
	    obj[key] = value;
	  }

	  return obj;
	}

	module.exports = _defineProperty;
	module.exports["default"] = module.exports, module.exports.__esModule = true;
	});

	var _defineProperty = unwrapExports(defineProperty);

	var runtime_1 = createCommonjsModule(function (module) {
	/**
	 * Copyright (c) 2014-present, Facebook, Inc.
	 *
	 * This source code is licensed under the MIT license found in the
	 * LICENSE file in the root directory of this source tree.
	 */

	var runtime = (function (exports) {

	  var Op = Object.prototype;
	  var hasOwn = Op.hasOwnProperty;
	  var undefined$1; // More compressible than void 0.
	  var $Symbol = typeof Symbol === "function" ? Symbol : {};
	  var iteratorSymbol = $Symbol.iterator || "@@iterator";
	  var asyncIteratorSymbol = $Symbol.asyncIterator || "@@asyncIterator";
	  var toStringTagSymbol = $Symbol.toStringTag || "@@toStringTag";

	  function define(obj, key, value) {
	    Object.defineProperty(obj, key, {
	      value: value,
	      enumerable: true,
	      configurable: true,
	      writable: true
	    });
	    return obj[key];
	  }
	  try {
	    // IE 8 has a broken Object.defineProperty that only works on DOM objects.
	    define({}, "");
	  } catch (err) {
	    define = function(obj, key, value) {
	      return obj[key] = value;
	    };
	  }

	  function wrap(innerFn, outerFn, self, tryLocsList) {
	    // If outerFn provided and outerFn.prototype is a Generator, then outerFn.prototype instanceof Generator.
	    var protoGenerator = outerFn && outerFn.prototype instanceof Generator ? outerFn : Generator;
	    var generator = Object.create(protoGenerator.prototype);
	    var context = new Context(tryLocsList || []);

	    // The ._invoke method unifies the implementations of the .next,
	    // .throw, and .return methods.
	    generator._invoke = makeInvokeMethod(innerFn, self, context);

	    return generator;
	  }
	  exports.wrap = wrap;

	  // Try/catch helper to minimize deoptimizations. Returns a completion
	  // record like context.tryEntries[i].completion. This interface could
	  // have been (and was previously) designed to take a closure to be
	  // invoked without arguments, but in all the cases we care about we
	  // already have an existing method we want to call, so there's no need
	  // to create a new function object. We can even get away with assuming
	  // the method takes exactly one argument, since that happens to be true
	  // in every case, so we don't have to touch the arguments object. The
	  // only additional allocation required is the completion record, which
	  // has a stable shape and so hopefully should be cheap to allocate.
	  function tryCatch(fn, obj, arg) {
	    try {
	      return { type: "normal", arg: fn.call(obj, arg) };
	    } catch (err) {
	      return { type: "throw", arg: err };
	    }
	  }

	  var GenStateSuspendedStart = "suspendedStart";
	  var GenStateSuspendedYield = "suspendedYield";
	  var GenStateExecuting = "executing";
	  var GenStateCompleted = "completed";

	  // Returning this object from the innerFn has the same effect as
	  // breaking out of the dispatch switch statement.
	  var ContinueSentinel = {};

	  // Dummy constructor functions that we use as the .constructor and
	  // .constructor.prototype properties for functions that return Generator
	  // objects. For full spec compliance, you may wish to configure your
	  // minifier not to mangle the names of these two functions.
	  function Generator() {}
	  function GeneratorFunction() {}
	  function GeneratorFunctionPrototype() {}

	  // This is a polyfill for %IteratorPrototype% for environments that
	  // don't natively support it.
	  var IteratorPrototype = {};
	  IteratorPrototype[iteratorSymbol] = function () {
	    return this;
	  };

	  var getProto = Object.getPrototypeOf;
	  var NativeIteratorPrototype = getProto && getProto(getProto(values([])));
	  if (NativeIteratorPrototype &&
	      NativeIteratorPrototype !== Op &&
	      hasOwn.call(NativeIteratorPrototype, iteratorSymbol)) {
	    // This environment has a native %IteratorPrototype%; use it instead
	    // of the polyfill.
	    IteratorPrototype = NativeIteratorPrototype;
	  }

	  var Gp = GeneratorFunctionPrototype.prototype =
	    Generator.prototype = Object.create(IteratorPrototype);
	  GeneratorFunction.prototype = Gp.constructor = GeneratorFunctionPrototype;
	  GeneratorFunctionPrototype.constructor = GeneratorFunction;
	  GeneratorFunction.displayName = define(
	    GeneratorFunctionPrototype,
	    toStringTagSymbol,
	    "GeneratorFunction"
	  );

	  // Helper for defining the .next, .throw, and .return methods of the
	  // Iterator interface in terms of a single ._invoke method.
	  function defineIteratorMethods(prototype) {
	    ["next", "throw", "return"].forEach(function(method) {
	      define(prototype, method, function(arg) {
	        return this._invoke(method, arg);
	      });
	    });
	  }

	  exports.isGeneratorFunction = function(genFun) {
	    var ctor = typeof genFun === "function" && genFun.constructor;
	    return ctor
	      ? ctor === GeneratorFunction ||
	        // For the native GeneratorFunction constructor, the best we can
	        // do is to check its .name property.
	        (ctor.displayName || ctor.name) === "GeneratorFunction"
	      : false;
	  };

	  exports.mark = function(genFun) {
	    if (Object.setPrototypeOf) {
	      Object.setPrototypeOf(genFun, GeneratorFunctionPrototype);
	    } else {
	      genFun.__proto__ = GeneratorFunctionPrototype;
	      define(genFun, toStringTagSymbol, "GeneratorFunction");
	    }
	    genFun.prototype = Object.create(Gp);
	    return genFun;
	  };

	  // Within the body of any async function, `await x` is transformed to
	  // `yield regeneratorRuntime.awrap(x)`, so that the runtime can test
	  // `hasOwn.call(value, "__await")` to determine if the yielded value is
	  // meant to be awaited.
	  exports.awrap = function(arg) {
	    return { __await: arg };
	  };

	  function AsyncIterator(generator, PromiseImpl) {
	    function invoke(method, arg, resolve, reject) {
	      var record = tryCatch(generator[method], generator, arg);
	      if (record.type === "throw") {
	        reject(record.arg);
	      } else {
	        var result = record.arg;
	        var value = result.value;
	        if (value &&
	            typeof value === "object" &&
	            hasOwn.call(value, "__await")) {
	          return PromiseImpl.resolve(value.__await).then(function(value) {
	            invoke("next", value, resolve, reject);
	          }, function(err) {
	            invoke("throw", err, resolve, reject);
	          });
	        }

	        return PromiseImpl.resolve(value).then(function(unwrapped) {
	          // When a yielded Promise is resolved, its final value becomes
	          // the .value of the Promise<{value,done}> result for the
	          // current iteration.
	          result.value = unwrapped;
	          resolve(result);
	        }, function(error) {
	          // If a rejected Promise was yielded, throw the rejection back
	          // into the async generator function so it can be handled there.
	          return invoke("throw", error, resolve, reject);
	        });
	      }
	    }

	    var previousPromise;

	    function enqueue(method, arg) {
	      function callInvokeWithMethodAndArg() {
	        return new PromiseImpl(function(resolve, reject) {
	          invoke(method, arg, resolve, reject);
	        });
	      }

	      return previousPromise =
	        // If enqueue has been called before, then we want to wait until
	        // all previous Promises have been resolved before calling invoke,
	        // so that results are always delivered in the correct order. If
	        // enqueue has not been called before, then it is important to
	        // call invoke immediately, without waiting on a callback to fire,
	        // so that the async generator function has the opportunity to do
	        // any necessary setup in a predictable way. This predictability
	        // is why the Promise constructor synchronously invokes its
	        // executor callback, and why async functions synchronously
	        // execute code before the first await. Since we implement simple
	        // async functions in terms of async generators, it is especially
	        // important to get this right, even though it requires care.
	        previousPromise ? previousPromise.then(
	          callInvokeWithMethodAndArg,
	          // Avoid propagating failures to Promises returned by later
	          // invocations of the iterator.
	          callInvokeWithMethodAndArg
	        ) : callInvokeWithMethodAndArg();
	    }

	    // Define the unified helper method that is used to implement .next,
	    // .throw, and .return (see defineIteratorMethods).
	    this._invoke = enqueue;
	  }

	  defineIteratorMethods(AsyncIterator.prototype);
	  AsyncIterator.prototype[asyncIteratorSymbol] = function () {
	    return this;
	  };
	  exports.AsyncIterator = AsyncIterator;

	  // Note that simple async functions are implemented on top of
	  // AsyncIterator objects; they just return a Promise for the value of
	  // the final result produced by the iterator.
	  exports.async = function(innerFn, outerFn, self, tryLocsList, PromiseImpl) {
	    if (PromiseImpl === void 0) PromiseImpl = Promise;

	    var iter = new AsyncIterator(
	      wrap(innerFn, outerFn, self, tryLocsList),
	      PromiseImpl
	    );

	    return exports.isGeneratorFunction(outerFn)
	      ? iter // If outerFn is a generator, return the full iterator.
	      : iter.next().then(function(result) {
	          return result.done ? result.value : iter.next();
	        });
	  };

	  function makeInvokeMethod(innerFn, self, context) {
	    var state = GenStateSuspendedStart;

	    return function invoke(method, arg) {
	      if (state === GenStateExecuting) {
	        throw new Error("Generator is already running");
	      }

	      if (state === GenStateCompleted) {
	        if (method === "throw") {
	          throw arg;
	        }

	        // Be forgiving, per 25.3.3.3.3 of the spec:
	        // https://people.mozilla.org/~jorendorff/es6-draft.html#sec-generatorresume
	        return doneResult();
	      }

	      context.method = method;
	      context.arg = arg;

	      while (true) {
	        var delegate = context.delegate;
	        if (delegate) {
	          var delegateResult = maybeInvokeDelegate(delegate, context);
	          if (delegateResult) {
	            if (delegateResult === ContinueSentinel) continue;
	            return delegateResult;
	          }
	        }

	        if (context.method === "next") {
	          // Setting context._sent for legacy support of Babel's
	          // function.sent implementation.
	          context.sent = context._sent = context.arg;

	        } else if (context.method === "throw") {
	          if (state === GenStateSuspendedStart) {
	            state = GenStateCompleted;
	            throw context.arg;
	          }

	          context.dispatchException(context.arg);

	        } else if (context.method === "return") {
	          context.abrupt("return", context.arg);
	        }

	        state = GenStateExecuting;

	        var record = tryCatch(innerFn, self, context);
	        if (record.type === "normal") {
	          // If an exception is thrown from innerFn, we leave state ===
	          // GenStateExecuting and loop back for another invocation.
	          state = context.done
	            ? GenStateCompleted
	            : GenStateSuspendedYield;

	          if (record.arg === ContinueSentinel) {
	            continue;
	          }

	          return {
	            value: record.arg,
	            done: context.done
	          };

	        } else if (record.type === "throw") {
	          state = GenStateCompleted;
	          // Dispatch the exception by looping back around to the
	          // context.dispatchException(context.arg) call above.
	          context.method = "throw";
	          context.arg = record.arg;
	        }
	      }
	    };
	  }

	  // Call delegate.iterator[context.method](context.arg) and handle the
	  // result, either by returning a { value, done } result from the
	  // delegate iterator, or by modifying context.method and context.arg,
	  // setting context.delegate to null, and returning the ContinueSentinel.
	  function maybeInvokeDelegate(delegate, context) {
	    var method = delegate.iterator[context.method];
	    if (method === undefined$1) {
	      // A .throw or .return when the delegate iterator has no .throw
	      // method always terminates the yield* loop.
	      context.delegate = null;

	      if (context.method === "throw") {
	        // Note: ["return"] must be used for ES3 parsing compatibility.
	        if (delegate.iterator["return"]) {
	          // If the delegate iterator has a return method, give it a
	          // chance to clean up.
	          context.method = "return";
	          context.arg = undefined$1;
	          maybeInvokeDelegate(delegate, context);

	          if (context.method === "throw") {
	            // If maybeInvokeDelegate(context) changed context.method from
	            // "return" to "throw", let that override the TypeError below.
	            return ContinueSentinel;
	          }
	        }

	        context.method = "throw";
	        context.arg = new TypeError(
	          "The iterator does not provide a 'throw' method");
	      }

	      return ContinueSentinel;
	    }

	    var record = tryCatch(method, delegate.iterator, context.arg);

	    if (record.type === "throw") {
	      context.method = "throw";
	      context.arg = record.arg;
	      context.delegate = null;
	      return ContinueSentinel;
	    }

	    var info = record.arg;

	    if (! info) {
	      context.method = "throw";
	      context.arg = new TypeError("iterator result is not an object");
	      context.delegate = null;
	      return ContinueSentinel;
	    }

	    if (info.done) {
	      // Assign the result of the finished delegate to the temporary
	      // variable specified by delegate.resultName (see delegateYield).
	      context[delegate.resultName] = info.value;

	      // Resume execution at the desired location (see delegateYield).
	      context.next = delegate.nextLoc;

	      // If context.method was "throw" but the delegate handled the
	      // exception, let the outer generator proceed normally. If
	      // context.method was "next", forget context.arg since it has been
	      // "consumed" by the delegate iterator. If context.method was
	      // "return", allow the original .return call to continue in the
	      // outer generator.
	      if (context.method !== "return") {
	        context.method = "next";
	        context.arg = undefined$1;
	      }

	    } else {
	      // Re-yield the result returned by the delegate method.
	      return info;
	    }

	    // The delegate iterator is finished, so forget it and continue with
	    // the outer generator.
	    context.delegate = null;
	    return ContinueSentinel;
	  }

	  // Define Generator.prototype.{next,throw,return} in terms of the
	  // unified ._invoke helper method.
	  defineIteratorMethods(Gp);

	  define(Gp, toStringTagSymbol, "Generator");

	  // A Generator should always return itself as the iterator object when the
	  // @@iterator function is called on it. Some browsers' implementations of the
	  // iterator prototype chain incorrectly implement this, causing the Generator
	  // object to not be returned from this call. This ensures that doesn't happen.
	  // See https://github.com/facebook/regenerator/issues/274 for more details.
	  Gp[iteratorSymbol] = function() {
	    return this;
	  };

	  Gp.toString = function() {
	    return "[object Generator]";
	  };

	  function pushTryEntry(locs) {
	    var entry = { tryLoc: locs[0] };

	    if (1 in locs) {
	      entry.catchLoc = locs[1];
	    }

	    if (2 in locs) {
	      entry.finallyLoc = locs[2];
	      entry.afterLoc = locs[3];
	    }

	    this.tryEntries.push(entry);
	  }

	  function resetTryEntry(entry) {
	    var record = entry.completion || {};
	    record.type = "normal";
	    delete record.arg;
	    entry.completion = record;
	  }

	  function Context(tryLocsList) {
	    // The root entry object (effectively a try statement without a catch
	    // or a finally block) gives us a place to store values thrown from
	    // locations where there is no enclosing try statement.
	    this.tryEntries = [{ tryLoc: "root" }];
	    tryLocsList.forEach(pushTryEntry, this);
	    this.reset(true);
	  }

	  exports.keys = function(object) {
	    var keys = [];
	    for (var key in object) {
	      keys.push(key);
	    }
	    keys.reverse();

	    // Rather than returning an object with a next method, we keep
	    // things simple and return the next function itself.
	    return function next() {
	      while (keys.length) {
	        var key = keys.pop();
	        if (key in object) {
	          next.value = key;
	          next.done = false;
	          return next;
	        }
	      }

	      // To avoid creating an additional object, we just hang the .value
	      // and .done properties off the next function object itself. This
	      // also ensures that the minifier will not anonymize the function.
	      next.done = true;
	      return next;
	    };
	  };

	  function values(iterable) {
	    if (iterable) {
	      var iteratorMethod = iterable[iteratorSymbol];
	      if (iteratorMethod) {
	        return iteratorMethod.call(iterable);
	      }

	      if (typeof iterable.next === "function") {
	        return iterable;
	      }

	      if (!isNaN(iterable.length)) {
	        var i = -1, next = function next() {
	          while (++i < iterable.length) {
	            if (hasOwn.call(iterable, i)) {
	              next.value = iterable[i];
	              next.done = false;
	              return next;
	            }
	          }

	          next.value = undefined$1;
	          next.done = true;

	          return next;
	        };

	        return next.next = next;
	      }
	    }

	    // Return an iterator with no values.
	    return { next: doneResult };
	  }
	  exports.values = values;

	  function doneResult() {
	    return { value: undefined$1, done: true };
	  }

	  Context.prototype = {
	    constructor: Context,

	    reset: function(skipTempReset) {
	      this.prev = 0;
	      this.next = 0;
	      // Resetting context._sent for legacy support of Babel's
	      // function.sent implementation.
	      this.sent = this._sent = undefined$1;
	      this.done = false;
	      this.delegate = null;

	      this.method = "next";
	      this.arg = undefined$1;

	      this.tryEntries.forEach(resetTryEntry);

	      if (!skipTempReset) {
	        for (var name in this) {
	          // Not sure about the optimal order of these conditions:
	          if (name.charAt(0) === "t" &&
	              hasOwn.call(this, name) &&
	              !isNaN(+name.slice(1))) {
	            this[name] = undefined$1;
	          }
	        }
	      }
	    },

	    stop: function() {
	      this.done = true;

	      var rootEntry = this.tryEntries[0];
	      var rootRecord = rootEntry.completion;
	      if (rootRecord.type === "throw") {
	        throw rootRecord.arg;
	      }

	      return this.rval;
	    },

	    dispatchException: function(exception) {
	      if (this.done) {
	        throw exception;
	      }

	      var context = this;
	      function handle(loc, caught) {
	        record.type = "throw";
	        record.arg = exception;
	        context.next = loc;

	        if (caught) {
	          // If the dispatched exception was caught by a catch block,
	          // then let that catch block handle the exception normally.
	          context.method = "next";
	          context.arg = undefined$1;
	        }

	        return !! caught;
	      }

	      for (var i = this.tryEntries.length - 1; i >= 0; --i) {
	        var entry = this.tryEntries[i];
	        var record = entry.completion;

	        if (entry.tryLoc === "root") {
	          // Exception thrown outside of any try block that could handle
	          // it, so set the completion value of the entire function to
	          // throw the exception.
	          return handle("end");
	        }

	        if (entry.tryLoc <= this.prev) {
	          var hasCatch = hasOwn.call(entry, "catchLoc");
	          var hasFinally = hasOwn.call(entry, "finallyLoc");

	          if (hasCatch && hasFinally) {
	            if (this.prev < entry.catchLoc) {
	              return handle(entry.catchLoc, true);
	            } else if (this.prev < entry.finallyLoc) {
	              return handle(entry.finallyLoc);
	            }

	          } else if (hasCatch) {
	            if (this.prev < entry.catchLoc) {
	              return handle(entry.catchLoc, true);
	            }

	          } else if (hasFinally) {
	            if (this.prev < entry.finallyLoc) {
	              return handle(entry.finallyLoc);
	            }

	          } else {
	            throw new Error("try statement without catch or finally");
	          }
	        }
	      }
	    },

	    abrupt: function(type, arg) {
	      for (var i = this.tryEntries.length - 1; i >= 0; --i) {
	        var entry = this.tryEntries[i];
	        if (entry.tryLoc <= this.prev &&
	            hasOwn.call(entry, "finallyLoc") &&
	            this.prev < entry.finallyLoc) {
	          var finallyEntry = entry;
	          break;
	        }
	      }

	      if (finallyEntry &&
	          (type === "break" ||
	           type === "continue") &&
	          finallyEntry.tryLoc <= arg &&
	          arg <= finallyEntry.finallyLoc) {
	        // Ignore the finally entry if control is not jumping to a
	        // location outside the try/catch block.
	        finallyEntry = null;
	      }

	      var record = finallyEntry ? finallyEntry.completion : {};
	      record.type = type;
	      record.arg = arg;

	      if (finallyEntry) {
	        this.method = "next";
	        this.next = finallyEntry.finallyLoc;
	        return ContinueSentinel;
	      }

	      return this.complete(record);
	    },

	    complete: function(record, afterLoc) {
	      if (record.type === "throw") {
	        throw record.arg;
	      }

	      if (record.type === "break" ||
	          record.type === "continue") {
	        this.next = record.arg;
	      } else if (record.type === "return") {
	        this.rval = this.arg = record.arg;
	        this.method = "return";
	        this.next = "end";
	      } else if (record.type === "normal" && afterLoc) {
	        this.next = afterLoc;
	      }

	      return ContinueSentinel;
	    },

	    finish: function(finallyLoc) {
	      for (var i = this.tryEntries.length - 1; i >= 0; --i) {
	        var entry = this.tryEntries[i];
	        if (entry.finallyLoc === finallyLoc) {
	          this.complete(entry.completion, entry.afterLoc);
	          resetTryEntry(entry);
	          return ContinueSentinel;
	        }
	      }
	    },

	    "catch": function(tryLoc) {
	      for (var i = this.tryEntries.length - 1; i >= 0; --i) {
	        var entry = this.tryEntries[i];
	        if (entry.tryLoc === tryLoc) {
	          var record = entry.completion;
	          if (record.type === "throw") {
	            var thrown = record.arg;
	            resetTryEntry(entry);
	          }
	          return thrown;
	        }
	      }

	      // The context.catch method must only be called with a location
	      // argument that corresponds to a known catch block.
	      throw new Error("illegal catch attempt");
	    },

	    delegateYield: function(iterable, resultName, nextLoc) {
	      this.delegate = {
	        iterator: values(iterable),
	        resultName: resultName,
	        nextLoc: nextLoc
	      };

	      if (this.method === "next") {
	        // Deliberately forget the last sent value so that we don't
	        // accidentally pass it on to the delegate.
	        this.arg = undefined$1;
	      }

	      return ContinueSentinel;
	    }
	  };

	  // Regardless of whether this script is executing as a CommonJS module
	  // or not, return the runtime object so that we can declare the variable
	  // regeneratorRuntime in the outer scope, which allows this module to be
	  // injected easily by `bin/regenerator --include-runtime script.js`.
	  return exports;

	}(
	  // If this script is executing as a CommonJS module, use module.exports
	  // as the regeneratorRuntime namespace. Otherwise create a new empty
	  // object. Either way, the resulting object will be used to initialize
	  // the regeneratorRuntime variable at the top of this file.
	  module.exports 
	));

	try {
	  regeneratorRuntime = runtime;
	} catch (accidentalStrictMode) {
	  // This module should not be running in strict mode, so the above
	  // assignment should always work unless something is misconfigured. Just
	  // in case runtime.js accidentally runs in strict mode, we can escape
	  // strict mode using a global Function call. This could conceivably fail
	  // if a Content Security Policy forbids using Function, but in that case
	  // the proper solution is to fix the accidental strict mode problem. If
	  // you've misconfigured your bundler to force strict mode and applied a
	  // CSP to forbid Function, and you're not willing to fix either of those
	  // problems, please detail your unique predicament in a GitHub issue.
	  Function("r", "regeneratorRuntime = r")(runtime);
	}
	});

	var regenerator = runtime_1;

	function _createSuper$d(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$d(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

	function _isNativeReflectConstruct$d() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

	function AuthMixinGenerator(auth) {
	  return function (Base) {
	    return /*#__PURE__*/function (_Base) {
	      _inherits(_class2, _Base);

	      var _super = _createSuper$d(_class2);

	      function _class2() {
	        var _this;

	        _classCallCheck(this, _class2);

	        for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
	          args[_key] = arguments[_key];
	        }

	        _this = _super.call.apply(_super, [this].concat(args));

	        _defineProperty(_assertThisInitialized(_this), "auth", void 0);

	        _this.auth = auth;

	        _this.auth.on('login', function () {
	          if (_this.requestUpdate) _this.requestUpdate('auth');
	        });

	        _this.auth.on('logout', function () {
	          if (_this.requestUpdate) _this.requestUpdate('auth');
	        });

	        return _this;
	      }

	      return _class2;
	    }(Base);
	  };
	}

	var isNativeFunction = createCommonjsModule(function (module) {
	function _isNativeFunction(fn) {
	  return Function.toString.call(fn).indexOf("[native code]") !== -1;
	}

	module.exports = _isNativeFunction;
	module.exports["default"] = module.exports, module.exports.__esModule = true;
	});

	unwrapExports(isNativeFunction);

	var isNativeReflectConstruct = createCommonjsModule(function (module) {
	function _isNativeReflectConstruct() {
	  if (typeof Reflect === "undefined" || !Reflect.construct) return false;
	  if (Reflect.construct.sham) return false;
	  if (typeof Proxy === "function") return true;

	  try {
	    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {}));
	    return true;
	  } catch (e) {
	    return false;
	  }
	}

	module.exports = _isNativeReflectConstruct;
	module.exports["default"] = module.exports, module.exports.__esModule = true;
	});

	unwrapExports(isNativeReflectConstruct);

	var construct = createCommonjsModule(function (module) {
	function _construct(Parent, args, Class) {
	  if (isNativeReflectConstruct()) {
	    module.exports = _construct = Reflect.construct;
	    module.exports["default"] = module.exports, module.exports.__esModule = true;
	  } else {
	    module.exports = _construct = function _construct(Parent, args, Class) {
	      var a = [null];
	      a.push.apply(a, args);
	      var Constructor = Function.bind.apply(Parent, a);
	      var instance = new Constructor();
	      if (Class) setPrototypeOf(instance, Class.prototype);
	      return instance;
	    };

	    module.exports["default"] = module.exports, module.exports.__esModule = true;
	  }

	  return _construct.apply(null, arguments);
	}

	module.exports = _construct;
	module.exports["default"] = module.exports, module.exports.__esModule = true;
	});

	unwrapExports(construct);

	var wrapNativeSuper = createCommonjsModule(function (module) {
	function _wrapNativeSuper(Class) {
	  var _cache = typeof Map === "function" ? new Map() : undefined;

	  module.exports = _wrapNativeSuper = function _wrapNativeSuper(Class) {
	    if (Class === null || !isNativeFunction(Class)) return Class;

	    if (typeof Class !== "function") {
	      throw new TypeError("Super expression must either be null or a function");
	    }

	    if (typeof _cache !== "undefined") {
	      if (_cache.has(Class)) return _cache.get(Class);

	      _cache.set(Class, Wrapper);
	    }

	    function Wrapper() {
	      return construct(Class, arguments, getPrototypeOf(this).constructor);
	    }

	    Wrapper.prototype = Object.create(Class.prototype, {
	      constructor: {
	        value: Wrapper,
	        enumerable: false,
	        writable: true,
	        configurable: true
	      }
	    });
	    return setPrototypeOf(Wrapper, Class);
	  };

	  module.exports["default"] = module.exports, module.exports.__esModule = true;
	  return _wrapNativeSuper(Class);
	}

	module.exports = _wrapNativeSuper;
	module.exports["default"] = module.exports, module.exports.__esModule = true;
	});

	var _wrapNativeSuper = unwrapExports(wrapNativeSuper);

	function _createSuper$c(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$c(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

	function _isNativeReflectConstruct$c() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

	var SalteAuthError = /*#__PURE__*/function (_Error) {
	  _inherits(SalteAuthError, _Error);

	  var _super = _createSuper$c(SalteAuthError);

	  function SalteAuthError(_ref) {
	    var _this;

	    var message = _ref.message,
	        code = _ref.code;

	    _classCallCheck(this, SalteAuthError);

	    _this = _super.call(this, message);

	    _defineProperty(_assertThisInitialized(_this), "code", void 0);

	    _this.code = code;
	    return _this;
	  }

	  return SalteAuthError;
	}( /*#__PURE__*/_wrapNativeSuper(Error));

	var Required = /*#__PURE__*/function () {
	  function Required(config) {
	    _classCallCheck(this, Required);

	    this.config = config || {};
	  }

	  _createClass(Required, [{
	    key: "required",
	    value: function required() {
	      var _this = this;

	      for (var _len = arguments.length, keys = new Array(_len), _key = 0; _key < _len; _key++) {
	        keys[_key] = arguments[_key];
	      }

	      var missing = keys.filter(function (key) {
	        return _this.config[key] === undefined;
	      });

	      if (missing.length > 0) {
	        throw new SalteAuthError({
	          code: 'missing_required_properties',
	          message: "Missing the following required fields. (".concat(missing.join(', '), ")")
	        });
	      }
	    }
	  }]);

	  return Required;
	}();

	var Fetch = /*#__PURE__*/function () {
	  function Fetch() {
	    _classCallCheck(this, Fetch);
	  }

	  _createClass(Fetch, null, [{
	    key: "setup",
	    value: function setup(force) {
	      if (this.hasSetup && !force) return;
	      this.hasSetup = true;
	      this.interceptors = [];
	      if (!this.real) this.real = window.fetch;

	      if (window.fetch) {
	        window.fetch = /*#__PURE__*/function () {
	          var _ref = _asyncToGenerator( /*#__PURE__*/regenerator.mark(function _callee(input, options) {
	            var request, i, interceptor;
	            return regenerator.wrap(function _callee$(_context) {
	              while (1) {
	                switch (_context.prev = _context.next) {
	                  case 0:
	                    request = input instanceof Request ? input : new Request(input, options);
	                    i = 0;

	                  case 2:
	                    if (!(i < Fetch.interceptors.length)) {
	                      _context.next = 9;
	                      break;
	                    }

	                    interceptor = Fetch.interceptors[i];
	                    _context.next = 6;
	                    return Promise.resolve(interceptor(request));

	                  case 6:
	                    i++;
	                    _context.next = 2;
	                    break;

	                  case 9:
	                    return _context.abrupt("return", Fetch.real.call(this, request));

	                  case 10:
	                  case "end":
	                    return _context.stop();
	                }
	              }
	            }, _callee, this);
	          }));

	          return function (_x, _x2) {
	            return _ref.apply(this, arguments);
	          };
	        }();
	      }
	    }
	  }, {
	    key: "add",
	    value: function add(interceptor) {
	      this.setup();
	      this.interceptors.push(interceptor);
	    }
	  }]);

	  return Fetch;
	}();

	_defineProperty(Fetch, "real", void 0);

	_defineProperty(Fetch, "hasSetup", false);

	_defineProperty(Fetch, "interceptors", void 0);

	var setup = false;
	var callbacks = [];

	function onRouteChange() {
	  callbacks.forEach(function (callback) {
	    return callback();
	  });
	}

	var Events$1 = /*#__PURE__*/function () {
	  function Events() {
	    _classCallCheck(this, Events);
	  }

	  _createClass(Events, null, [{
	    key: "route",
	    value: function route(callback) {
	      if (!setup) {
	        window.addEventListener('popstate', onRouteChange, {
	          passive: true
	        });
	        window.addEventListener('click', onRouteChange, {
	          passive: true
	        });
	        setTimeout(onRouteChange);
	        setup = true;
	      }

	      callbacks.push(callback);
	    }
	  }, {
	    key: "create",
	    value: function create(name, params) {
	      var event = document.createEvent('Event');
	      event.initEvent(name, params.bubbles || false, params.cancelable || true);
	      event.detail = params.detail;
	      return event;
	    }
	  }, {
	    key: "isCrossDomainError",
	    value: function isCrossDomainError(e) {
	      return e instanceof DOMException || e.message === 'Permission denied';
	    }
	  }]);

	  return Events;
	}();

	var XHR = /*#__PURE__*/function () {
	  function XHR() {
	    _classCallCheck(this, XHR);
	  }

	  _createClass(XHR, null, [{
	    key: "setup",
	    value: function setup(force) {
	      if (this.hasSetup && !force) return;
	      this.hasSetup = true;
	      this.interceptors = [];
	      if (!this.realOpen) this.realOpen = XMLHttpRequest.prototype.open;
	      if (!this.realSend) this.realSend = XMLHttpRequest.prototype.send;
	      var requestPrototype = XMLHttpRequest.prototype;

	      requestPrototype.open = function () {
	        for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
	          args[_key] = arguments[_key];
	        }

	        var url = args[1];
	        this.$url = url;
	        return XHR.realOpen.apply(this, args);
	      };

	      requestPrototype.send = function (data) {
	        var _this = this;

	        var promises = [];

	        for (var i = 0; i < XHR.interceptors.length; i++) {
	          var interceptor = XHR.interceptors[i];
	          promises.push(interceptor(this, data));
	        }

	        Promise.all(promises).then(function () {
	          XHR.realSend.call(_this, data);
	        }).catch(function (error) {
	          _this.dispatchEvent(Events$1.create('error', {
	            detail: error
	          }));
	        });
	      };
	    }
	  }, {
	    key: "add",
	    value: function add(interceptor) {
	      this.setup();
	      this.interceptors.push(interceptor);
	    }
	  }]);

	  return XHR;
	}();

	_defineProperty(XHR, "realOpen", void 0);

	_defineProperty(XHR, "realSend", void 0);

	_defineProperty(XHR, "hasSetup", false);

	_defineProperty(XHR, "interceptors", void 0);

	var index$2 = /*#__PURE__*/Object.freeze({
		__proto__: null,
		Fetch: Fetch,
		XHR: XHR
	});

	var arrayWithHoles = createCommonjsModule(function (module) {
	function _arrayWithHoles(arr) {
	  if (Array.isArray(arr)) return arr;
	}

	module.exports = _arrayWithHoles;
	module.exports["default"] = module.exports, module.exports.__esModule = true;
	});

	unwrapExports(arrayWithHoles);

	var iterableToArrayLimit = createCommonjsModule(function (module) {
	function _iterableToArrayLimit(arr, i) {
	  var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"];

	  if (_i == null) return;
	  var _arr = [];
	  var _n = true;
	  var _d = false;

	  var _s, _e;

	  try {
	    for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) {
	      _arr.push(_s.value);

	      if (i && _arr.length === i) break;
	    }
	  } catch (err) {
	    _d = true;
	    _e = err;
	  } finally {
	    try {
	      if (!_n && _i["return"] != null) _i["return"]();
	    } finally {
	      if (_d) throw _e;
	    }
	  }

	  return _arr;
	}

	module.exports = _iterableToArrayLimit;
	module.exports["default"] = module.exports, module.exports.__esModule = true;
	});

	unwrapExports(iterableToArrayLimit);

	var arrayLikeToArray = createCommonjsModule(function (module) {
	function _arrayLikeToArray(arr, len) {
	  if (len == null || len > arr.length) len = arr.length;

	  for (var i = 0, arr2 = new Array(len); i < len; i++) {
	    arr2[i] = arr[i];
	  }

	  return arr2;
	}

	module.exports = _arrayLikeToArray;
	module.exports["default"] = module.exports, module.exports.__esModule = true;
	});

	unwrapExports(arrayLikeToArray);

	var unsupportedIterableToArray = createCommonjsModule(function (module) {
	function _unsupportedIterableToArray(o, minLen) {
	  if (!o) return;
	  if (typeof o === "string") return arrayLikeToArray(o, minLen);
	  var n = Object.prototype.toString.call(o).slice(8, -1);
	  if (n === "Object" && o.constructor) n = o.constructor.name;
	  if (n === "Map" || n === "Set") return Array.from(o);
	  if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return arrayLikeToArray(o, minLen);
	}

	module.exports = _unsupportedIterableToArray;
	module.exports["default"] = module.exports, module.exports.__esModule = true;
	});

	unwrapExports(unsupportedIterableToArray);

	var nonIterableRest = createCommonjsModule(function (module) {
	function _nonIterableRest() {
	  throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
	}

	module.exports = _nonIterableRest;
	module.exports["default"] = module.exports, module.exports.__esModule = true;
	});

	unwrapExports(nonIterableRest);

	var slicedToArray = createCommonjsModule(function (module) {
	function _slicedToArray(arr, i) {
	  return arrayWithHoles(arr) || iterableToArrayLimit(arr, i) || unsupportedIterableToArray(arr, i) || nonIterableRest();
	}

	module.exports = _slicedToArray;
	module.exports["default"] = module.exports, module.exports.__esModule = true;
	});

	var _slicedToArray = unwrapExports(slicedToArray);

	var urlDocument;
	var base;
	var anchor;
	var URL = /*#__PURE__*/function () {
	  function URL() {
	    _classCallCheck(this, URL);
	  }

	  _createClass(URL, null, [{
	    key: "origin",
	    get:
	    /**
	     * Outputs a result equivalent to `location.origin`
	     */
	    function get() {
	      return "".concat(location.protocol, "//").concat(location.host);
	    }
	  }, {
	    key: "resolve",
	    value: function resolve(path) {
	      if (!urlDocument) {
	        urlDocument = document.implementation.createHTMLDocument('url');
	        base = urlDocument.createElement('base');
	        anchor = urlDocument.createElement('a');
	        urlDocument.head.appendChild(base);
	      }

	      base.href = window.location.protocol + '//' + window.location.host;
	      anchor.href = path.replace(/ /g, '%20');
	      return anchor.href.replace(/\/$/, '');
	    }
	  }, {
	    key: "match",
	    value: function match(url, tests) {
	      var _this = this;

	      if (tests instanceof Array) {
	        var resolvedUrl = this.resolve(url);
	        var match = Common.find(tests, function (test) {
	          if (test instanceof RegExp) {
	            return !!resolvedUrl.match(test);
	          }

	          return resolvedUrl.indexOf(_this.resolve(test)) === 0;
	        });
	        return !!match;
	      }

	      return tests === true;
	    }
	  }, {
	    key: "parse",
	    value: function parse(_ref) {
	      var search = _ref.search,
	          hash = _ref.hash;
	      var params = [];
	      if (search) params = params.concat(search.replace('?', '').split('&'));
	      if (hash) params = params.concat(hash.replace('#', '').split('&'));
	      var parsed = {};
	      Common.forEach(params, function (param) {
	        var _param$split = param.split('='),
	            _param$split2 = _slicedToArray(_param$split, 2),
	            key = _param$split2[0],
	            value = _param$split2[1];

	        parsed[key] = value;
	      });
	      return parsed;
	    }
	    /**
	     * Creates a url with the given query parameters
	     * @param base - the base url without query parameters
	     * @param params - the query parameters to attache to the url
	     * @returns the built url
	     */

	  }, {
	    key: "url",
	    value: function url(base, params) {
	      var url = base;
	      Common.forEach(params, function (value, key) {
	        if (Common.includes([undefined, null, ''], value)) return;
	        url += "".concat(url.indexOf('?') === -1 ? '?' : '&').concat(key, "=").concat(encodeURIComponent(value));
	      });
	      return url;
	    }
	  }]);

	  return URL;
	}();

	var debounces = {};
	var Common = /*#__PURE__*/function () {
	  function Common() {
	    _classCallCheck(this, Common);
	  }

	  _createClass(Common, null, [{
	    key: "includes",
	    value: function includes(source, value) {
	      return source.indexOf(value) !== -1;
	    }
	  }, {
	    key: "forEach",
	    value: function forEach(source, cb) {
	      if (Array.isArray(source)) {
	        for (var i = 0; i < source.length; i++) {
	          cb(source[i], i);
	        }
	      } else {
	        for (var _key in source) {
	          cb(source[_key], _key);
	        }
	      }
	    }
	  }, {
	    key: "find",
	    value: function find(source, cb) {
	      if (Array.isArray(source)) {
	        for (var i = 0; i < source.length; i++) {
	          var _item = source[i];

	          if (cb(_item, i)) {
	            return _item;
	          }
	        }
	      } else {
	        for (var _key2 in source) {
	          var _item2 = source[_key2];

	          if (cb(_item2, _key2)) {
	            return _item2;
	          }
	        }
	      }

	      return null;
	    }
	  }, {
	    key: "assign",
	    value: function assign(target) {
	      for (var _len = arguments.length, sources = new Array(_len > 1 ? _len - 1 : 0), _key3 = 1; _key3 < _len; _key3++) {
	        sources[_key3 - 1] = arguments[_key3];
	      }

	      this.forEach(sources, function (source) {
	        for (var _key4 in source) {
	          target[_key4] = source[_key4];
	        }
	      });
	      return target;
	    }
	  }, {
	    key: "defaults",
	    value: function defaults(target) {
	      var _this = this;

	      for (var _len2 = arguments.length, sources = new Array(_len2 > 1 ? _len2 - 1 : 0), _key5 = 1; _key5 < _len2; _key5++) {
	        sources[_key5 - 1] = arguments[_key5];
	      }

	      this.forEach(sources, function (source) {
	        for (var _key6 in source) {
	          if (_this.isObject(target[_key6]) && _this.isObject(source[_key6])) {
	            target[_key6] = _this.defaults(target[_key6], source[_key6]);
	          } else if (target[_key6] === undefined) {
	            target[_key6] = source[_key6];
	          }
	        }
	      });
	      return target;
	    }
	  }, {
	    key: "isObject",
	    value: function isObject(value) {
	      return _typeof(value) === 'object' && !Array.isArray(value);
	    }
	  }, {
	    key: "iframe",
	    value: function () {
	      var _iframe = _asyncToGenerator( /*#__PURE__*/regenerator.mark(function _callee(_ref) {
	        var _this2 = this;

	        var url, redirectUrl, visible, iframe;
	        return regenerator.wrap(function _callee$(_context) {
	          while (1) {
	            switch (_context.prev = _context.next) {
	              case 0:
	                url = _ref.url, redirectUrl = _ref.redirectUrl, visible = _ref.visible;
	                iframe = document.createElement('iframe');
	                iframe.setAttribute('owner', '@salte-auth/salte-auth');

	                if (visible) {
	                  this.assign(iframe.style, {
	                    border: 'none',
	                    bottom: 0,
	                    height: '100%',
	                    left: 0,
	                    position: 'fixed',
	                    right: 0,
	                    top: 0,
	                    width: '100%',
	                    zIndex: 9999,
	                    opacity: 0,
	                    transition: '0.5s opacity'
	                  });
	                  setTimeout(function () {
	                    return iframe.style.opacity = '1';
	                  });
	                } else {
	                  iframe.style.display = 'none';
	                }

	                iframe.src = url;
	                document.body.appendChild(iframe);
	                return _context.abrupt("return", new Promise(function (resolve, reject) {
	                  var checker = setInterval(function () {
	                    try {
	                      var location = iframe.contentWindow.location; // This could throw cross-domain errors, so we need to silence them.

	                      // This could throw cross-domain errors, so we need to silence them.
	                      if (location.href.indexOf(redirectUrl) !== 0) return;
	                      var parsed = URL.parse(location);

	                      _this2.removeIframe(iframe);

	                      clearInterval(checker);
	                      resolve(parsed);
	                    } catch (error) {
	                      if (Events$1.isCrossDomainError(error)) return;

	                      _this2.removeIframe(iframe);

	                      clearInterval(checker);
	                      reject(error);
	                    }
	                  });
	                }));

	              case 7:
	              case "end":
	                return _context.stop();
	            }
	          }
	        }, _callee, this);
	      }));

	      function iframe(_x) {
	        return _iframe.apply(this, arguments);
	      }

	      return iframe;
	    }()
	  }, {
	    key: "removeIframe",
	    value: function removeIframe(iframe) {
	      /* istanbul ignore if */
	      if (!iframe.parentElement) return;
	      iframe.parentElement.removeChild(iframe);
	    }
	  }, {
	    key: "debounce",
	    value: function debounce(identifier, callback, timeout) {
	      clearTimeout(debounces[identifier]);
	      debounces[identifier] = window.setTimeout(function () {
	        delete debounces[identifier];
	        callback();
	      }, timeout);
	    }
	  }]);

	  return Common;
	}();

	var Storage$1 = /*#__PURE__*/function () {
	  function Storage(baseKey) {
	    _classCallCheck(this, Storage);

	    _defineProperty(this, "baseKey", void 0);

	    this.baseKey = baseKey;
	  }
	  /**
	   * Determines if the current browser supports this storage type.
	   * @returns true if the storage type is supported
	   */


	  _createClass(Storage, [{
	    key: "has",
	    value: function has(name) {
	      return !Common.includes([undefined, null], this.get(name));
	    }
	    /**
	     * Returns a scoped key for storage.
	     * @param key - The storage key.
	     *
	     * @example Storage.key('hello') // 'salte.auth.handler.redirect.hello'
	     */

	  }, {
	    key: "key",
	    value: function key() {
	      var _key = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';

	      if (this.baseKey && _key.indexOf(this.baseKey) === -1) {
	        return "".concat(this.baseKey, ".").concat(_key);
	      }

	      return _key;
	    }
	  }], [{
	    key: "supported",
	    value: function supported() {
	      return true;
	    }
	  }]);

	  return Storage;
	}();

	function _createSuper$b(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$b(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

	function _isNativeReflectConstruct$b() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
	var CookieStorage = /*#__PURE__*/function (_Storage) {
	  _inherits(CookieStorage, _Storage);

	  var _super = _createSuper$b(CookieStorage);

	  function CookieStorage() {
	    _classCallCheck(this, CookieStorage);

	    return _super.apply(this, arguments);
	  }

	  _createClass(CookieStorage, [{
	    key: "get",
	    value: function get(name, defaultValue) {
	      var match = document.cookie.match(new RegExp("".concat(this.key(name), "=([^;]+)")));
	      var result = match && match[1].trim();
	      if (!Common.includes([undefined, null], result)) return result;else if (!Common.includes([undefined, null], defaultValue)) return defaultValue;
	      return null;
	    }
	  }, {
	    key: "set",
	    value: function set(name, value) {
	      if (Common.includes([undefined, null], value)) {
	        this.delete(name);
	      } else {
	        document.cookie = "".concat(this.key(name), "=").concat(value, "; SameSite=Lax");
	      }
	    }
	  }, {
	    key: "delete",
	    value: function _delete(name) {
	      document.cookie = "".concat(this.key(name), "=; expires=").concat(new Date(0).toUTCString());
	    }
	  }, {
	    key: "clear",
	    value: function clear() {
	      var _this = this;

	      var base = this.key();
	      var cookies = document.cookie.split(';');
	      Common.forEach(cookies, function (cookie) {
	        var _cookie$trim$split = cookie.trim().split('='),
	            _cookie$trim$split2 = _slicedToArray(_cookie$trim$split, 1),
	            name = _cookie$trim$split2[0];

	        if (name.indexOf(base) === 0) {
	          _this.delete(name);
	        }
	      });
	    }
	  }], [{
	    key: "supported",
	    value:
	    /**
	     * Determines if the current browser allows cookies.
	     * @returns true if cookies aren't disabled.
	     */
	    function supported() {
	      return navigator.cookieEnabled === true;
	    }
	  }]);

	  return CookieStorage;
	}(Storage$1);

	function _createSuper$a(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$a(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

	function _isNativeReflectConstruct$a() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
	var LocalStorage = /*#__PURE__*/function (_Storage) {
	  _inherits(LocalStorage, _Storage);

	  var _super = _createSuper$a(LocalStorage);

	  function LocalStorage() {
	    _classCallCheck(this, LocalStorage);

	    return _super.apply(this, arguments);
	  }

	  _createClass(LocalStorage, [{
	    key: "get",
	    value: function get(name, defaultValue) {
	      var result = localStorage.getItem(this.key(name));
	      if (!Common.includes([undefined, null], result)) return result;else if (!Common.includes([undefined, null], defaultValue)) return defaultValue;
	      return null;
	    }
	  }, {
	    key: "set",
	    value: function set(name, value) {
	      if (Common.includes([undefined, null], value)) {
	        this.delete(name);
	      } else {
	        localStorage.setItem(this.key(name), value);
	      }
	    }
	  }, {
	    key: "delete",
	    value: function _delete(name) {
	      localStorage.removeItem(this.key(name));
	    }
	  }, {
	    key: "clear",
	    value: function clear() {
	      var base = this.key();

	      for (var key in localStorage) {
	        if (key.indexOf(base) === 0) {
	          this.delete(key);
	        }
	      }
	    }
	  }]);

	  return LocalStorage;
	}(Storage$1);

	function _createSuper$9(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$9(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

	function _isNativeReflectConstruct$9() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
	var SessionStorage = /*#__PURE__*/function (_Storage) {
	  _inherits(SessionStorage, _Storage);

	  var _super = _createSuper$9(SessionStorage);

	  function SessionStorage() {
	    _classCallCheck(this, SessionStorage);

	    return _super.apply(this, arguments);
	  }

	  _createClass(SessionStorage, [{
	    key: "get",
	    value: function get(name, defaultValue) {
	      var result = sessionStorage.getItem(this.key(name));
	      if (!Common.includes([undefined, null], result)) return result;else if (!Common.includes([undefined, null], defaultValue)) return defaultValue;
	      return null;
	    }
	  }, {
	    key: "set",
	    value: function set(name, value) {
	      if (Common.includes([undefined, null], value)) {
	        this.delete(name);
	      } else {
	        sessionStorage.setItem(this.key(name), value);
	      }
	    }
	  }, {
	    key: "delete",
	    value: function _delete(name) {
	      sessionStorage.removeItem(this.key(name));
	    }
	  }, {
	    key: "clear",
	    value: function clear() {
	      var base = this.key();

	      for (var key in sessionStorage) {
	        if (key.indexOf(base) === 0) {
	          this.delete(key);
	        }
	      }
	    }
	  }]);

	  return SessionStorage;
	}(Storage$1);

	var StorageTypes = {
	  cookie: CookieStorage,
	  local: LocalStorage,
	  session: SessionStorage
	};

	var index$1 = /*#__PURE__*/Object.freeze({
		__proto__: null,
		StorageTypes: StorageTypes,
		CookieStorage: CookieStorage,
		LocalStorage: LocalStorage,
		SessionStorage: SessionStorage
	});

	var AccessToken = /*#__PURE__*/function () {
	  function AccessToken(accessToken, expiration, type) {
	    _classCallCheck(this, AccessToken);

	    _defineProperty(this, "raw", void 0);

	    _defineProperty(this, "expiration", void 0);

	    _defineProperty(this, "type", void 0);

	    this.raw = accessToken;
	    this.expiration = Common.includes([undefined, null], expiration) ? null : Number(expiration);
	    this.type = type;
	  }

	  _createClass(AccessToken, [{
	    key: "expired",
	    get: function get() {
	      return !this.raw || this.expiration <= Date.now();
	    }
	  }]);

	  return AccessToken;
	}();

	var IDToken = /*#__PURE__*/function () {
	  function IDToken(idToken) {
	    _classCallCheck(this, IDToken);

	    _defineProperty(this, "raw", void 0);

	    _defineProperty(this, "user", void 0);

	    this.raw = idToken;
	    this.user = IDToken.parse(this.raw);
	  }

	  _createClass(IDToken, [{
	    key: "expired",
	    get: function get() {
	      return !this.user || this.user.exp * 1000 <= Date.now();
	    }
	  }], [{
	    key: "parse",
	    value: function parse(idToken) {
	      try {
	        var separated = idToken.split('.');

	        if (separated.length !== 3) {
	          throw new SalteAuthError({
	            code: 'invalid_id_token',
	            message: "ID Token didn't match the desired format. ({header}.{payload}.{validation})"
	          });
	        } // This fixes an issue where various providers will encode values
	        // incorrectly and cause the browser to fail to decode.
	        // https://stackoverflow.com/questions/43065553/base64-decoded-differently-in-java-jjwt


	        return JSON.parse(atob(separated[1].replace(/-/g, '+').replace(/_/g, '/')));
	      } catch (error) {
	        return null;
	      }
	    }
	  }]);

	  return IDToken;
	}();

	var Logger = /*#__PURE__*/function () {
	  function Logger(name, level) {
	    _classCallCheck(this, Logger);

	    _defineProperty(this, "name", void 0);

	    _defineProperty(this, "level", void 0);

	    this.name = name;
	    this.level = typeof level === 'string' ? this.toLevel(level) : level;
	  }

	  _createClass(Logger, [{
	    key: "trace",
	    value: function trace(message) {
	      for (var _len = arguments.length, optionalParams = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
	        optionalParams[_key - 1] = arguments[_key];
	      }

	      this.log.apply(this, ['trace', message].concat(optionalParams));
	    }
	  }, {
	    key: "info",
	    value: function info(message) {
	      for (var _len2 = arguments.length, optionalParams = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
	        optionalParams[_key2 - 1] = arguments[_key2];
	      }

	      this.log.apply(this, ['info', message].concat(optionalParams));
	    }
	  }, {
	    key: "warn",
	    value: function warn(message) {
	      for (var _len3 = arguments.length, optionalParams = new Array(_len3 > 1 ? _len3 - 1 : 0), _key3 = 1; _key3 < _len3; _key3++) {
	        optionalParams[_key3 - 1] = arguments[_key3];
	      }

	      this.log.apply(this, ['warn', message].concat(optionalParams));
	    }
	  }, {
	    key: "error",
	    value: function error(message) {
	      for (var _len4 = arguments.length, optionalParams = new Array(_len4 > 1 ? _len4 - 1 : 0), _key4 = 1; _key4 < _len4; _key4++) {
	        optionalParams[_key4 - 1] = arguments[_key4];
	      }

	      this.log.apply(this, ['error', message].concat(optionalParams));
	    }
	  }, {
	    key: "log",
	    value: function log(level, message) {
	      if (this.enabled(level)) {
	        var _console;

	        for (var _len5 = arguments.length, optionalParams = new Array(_len5 > 2 ? _len5 - 2 : 0), _key5 = 2; _key5 < _len5; _key5++) {
	          optionalParams[_key5 - 2] = arguments[_key5];
	        }

	        (_console = console).log.apply(_console, ["".concat(level, ": ").concat(message)].concat(optionalParams));
	      }
	    }
	  }, {
	    key: "enabled",
	    value: function enabled(level) {
	      if (this.level === false) return false;
	      return this.level === true || this.level <= this.toLevel(level);
	    }
	  }, {
	    key: "toLevel",
	    value: function toLevel(name) {
	      return Common.find(Logger.levels, function (_level, key) {
	        return key === name;
	      });
	    }
	  }]);

	  return Logger;
	}();

	_defineProperty(Logger, "levels", {
	  trace: 0,
	  info: 1,
	  warn: 2,
	  error: 3
	});

	var Dedupe = /*#__PURE__*/function () {
	  function Dedupe() {
	    _classCallCheck(this, Dedupe);
	  }

	  _createClass(Dedupe, null, [{
	    key: "dedupe",
	    value: function dedupe() {
	      var dedupes = {};
	      return function (key, fn) {
	        if (!dedupes[key]) {
	          dedupes[key] = fn().then(function (response) {
	            delete dedupes[key];
	            return response;
	          }).catch(function (error) {
	            delete dedupes[key];
	            throw error;
	          });
	        }

	        return dedupes[key];
	      };
	    }
	  }]);

	  return Dedupe;
	}();

	var index = /*#__PURE__*/Object.freeze({
		__proto__: null,
		Interceptors: index$2,
		StorageHelpers: index$1,
		AccessToken: AccessToken,
		IDToken: IDToken,
		Common: Common,
		Events: Events$1,
		URL: URL,
		Logger: Logger,
		Dedupe: Dedupe
	});

	function _createSuper$8(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$8(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

	function _isNativeReflectConstruct$8() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
	var defaultStorageOrder = ['cookie', 'session', 'local'];
	var Storage = /*#__PURE__*/function (_Required) {
	  _inherits(Storage, _Required);

	  var _super = _createSuper$8(Storage);

	  function Storage(config) {
	    var _this;

	    _classCallCheck(this, Storage);

	    _this = _super.call(this, config);

	    _defineProperty(_assertThisInitialized(_this), "storage", void 0);

	    _this.config = Common.defaults(_this.config, {
	      storage: Common.find(defaultStorageOrder, function (storageType) {
	        return StorageTypes[storageType].supported();
	      })
	    });
	    var _Storage = StorageTypes[_this.config.storage];

	    if (_Storage) {
	      _this.storage = new _Storage(_this.key);
	    } else {
	      throw new SalteAuthError({
	        code: 'invalid_storage',
	        message: "Storage doesn't exist for the given value. (".concat(_this.config.storage, ")")
	      });
	    }

	    return _this;
	  }

	  _createClass(Storage, [{
	    key: "key",
	    get: function get() {
	      return 'salte.auth';
	    }
	  }]);

	  return Storage;
	}(Required);

	function _createSuper$7(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$7(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

	function _isNativeReflectConstruct$7() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
	var Events = /*#__PURE__*/function (_Storage) {
	  _inherits(Events, _Storage);

	  var _super = _createSuper$7(Events);

	  function Events() {
	    var _this;

	    _classCallCheck(this, Events);

	    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
	      args[_key] = arguments[_key];
	    }

	    _this = _super.call.apply(_super, [this].concat(args));

	    _defineProperty(_assertThisInitialized(_this), "listeners", new Map());

	    return _this;
	  }

	  _createClass(Events, [{
	    key: "on",
	    value: function on(name, listener) {
	      if (!this.listeners.has(name)) {
	        this.listeners.set(name, []);
	      }

	      var listeners = this.listeners.get(name);
	      listeners.push(listener);
	    }
	  }, {
	    key: "off",
	    value: function off(name, listener) {
	      if (!this.listeners.has(name)) return;
	      var listeners = this.listeners.get(name);
	      if (!listeners.length) return;
	      var index = listeners.indexOf(listener);
	      if (index === -1) return;
	      listeners.splice(index, 1);
	    }
	  }, {
	    key: "emit",
	    value: function emit(name) {
	      for (var _len2 = arguments.length, args = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
	        args[_key2 - 1] = arguments[_key2];
	      }

	      if (!this.listeners.has(name)) return;
	      var listeners = this.listeners.get(name);
	      Common.forEach(listeners, function (listener) {
	        return listener.apply(void 0, args);
	      });
	    }
	  }]);

	  return Events;
	}(Storage);

	function _createSuper$6(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$6(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

	function _isNativeReflectConstruct$6() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
	var Shared = /*#__PURE__*/function (_Events) {
	  _inherits(Shared, _Events);

	  var _super = _createSuper$6(Shared);

	  function Shared(config) {
	    var _this;

	    _classCallCheck(this, Shared);

	    _this = _super.call(this, config);
	    _this.config = Common.defaults(_this.config, {
	      redirectUrl: location.origin,
	      level: 'warn'
	    });
	    return _this;
	  }
	  /**
	   * Returns a redirect url for the given login type.
	   * @param type - Are we logging in or logging out?
	   */


	  _createClass(Shared, [{
	    key: "redirectUrl",
	    value: function redirectUrl(type) {
	      if (typeof this.config.redirectUrl === 'string') {
	        return this.config.redirectUrl;
	      }

	      return this.config.redirectUrl[type];
	    }
	  }]);

	  return Shared;
	}(Events);

	// This file replaces `index.js` in bundlers like webpack or Rollup,

	var crypto = self.crypto || self.msCrypto;

	// This alphabet uses a-z A-Z 0-9 _- symbols.
	// Symbols are generated for smaller size.
	// -_zyxwvutsrqponmlkjihgfedcba9876543210ZYXWVUTSRQPONMLKJIHGFEDCBA
	var url = '-_';
	// Loop from 36 to 0 (from z to a and 9 to 0 in Base36).
	var i = 36;
	while (i--) {
	  // 36 is radix. Number.prototype.toString(36) returns number
	  // in Base36 representation. Base36 is like hex, but it uses 0–9 and a-z.
	  url += i.toString(36);
	}
	// Loop from 36 to 10 (from Z to A in Base36).
	i = 36;
	while (i-- - 10) {
	  url += i.toString(36).toUpperCase();
	}

	var index_browser = function (size) {
	  var id = '';
	  var bytes = crypto.getRandomValues(new Uint8Array(size || 21));
	  i = size || 21;

	  // Compact alternative for `for (var i = 0; i < size; i++)`
	  while (i--) {
	    // We can’t use bytes bigger than the alphabet. 63 is 00111111 bitmask.
	    // This mask reduces random byte 0-255 to 0-63 values.
	    // There is no need in `|| ''` and `* 1.6` hacks in here,
	    // because bitmask trim bytes exact to alphabet size.
	    id += url[bytes[i] & 63];
	  }
	  return id
	};

	function _createSuper$5(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$5(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

	function _isNativeReflectConstruct$5() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
	var Provider = /*#__PURE__*/function (_Shared) {
	  _inherits(Provider, _Shared);

	  var _super = _createSuper$5(Provider);

	  function Provider(config) {
	    var _this;

	    _classCallCheck(this, Provider);

	    _this = _super.call(this, config);

	    _defineProperty(_assertThisInitialized(_this), "logger", void 0);

	    _defineProperty(_assertThisInitialized(_this), "url", URL.url);

	    _defineProperty(_assertThisInitialized(_this), "dedupe", Dedupe.dedupe());

	    _this.config = Common.defaults(_this.config, {
	      validation: true,
	      level: 'warn'
	    });
	    _this.logger = new Logger("@salte-auth/salte-auth:providers/".concat(_this.$name), _this.config.level);
	    return _this;
	  }
	  /**
	   * Determines if validation is enabled for the given key.
	   * @param key - the key to determine whether validation is enabled for
	   * @returns whether validation is enabled for the key.
	   */


	  _createClass(Provider, [{
	    key: "validation",
	    value: function validation(key) {
	      if (_typeof(this.config.validation) === 'object') {
	        return this.config.validation[key] === true;
	      }

	      return this.config.validation === true;
	    }
	    /**
	     * The unique name of the provider
	     */

	  }, {
	    key: "$name",
	    get: function get() {
	      return this.config.name || this.name;
	    }
	    /**
	     * Returns a scoped key for storage.
	     * @param key - The storage key.
	     *
	     * @example auth0.key('hello') // 'salte.auth.provider.auth0.hello'
	     */

	  }, {
	    key: "key",
	    get: function get() {
	      return "salte.auth.provider.".concat(this.$name);
	    }
	  }, {
	    key: "logout",
	    get:
	    /**
	     * Returns the logout url for the provider.
	     */
	    function get() {
	      throw new SalteAuthError({
	        code: 'logout_not_supported',
	        message: "This provider doesn't support logout."
	      });
	    }
	  }]);

	  return Provider;
	}(Shared);

	function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

	function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

	function _createSuper$4(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$4(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

	function _isNativeReflectConstruct$4() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
	var OAuth2Provider = /*#__PURE__*/function (_Provider) {
	  _inherits(OAuth2Provider, _Provider);

	  var _super = _createSuper$4(OAuth2Provider);

	  function OAuth2Provider(config) {
	    var _this;

	    _classCallCheck(this, OAuth2Provider);

	    _this = _super.call(this, config);

	    _defineProperty(_assertThisInitialized(_this), "accessToken", void 0);

	    _this.sync();

	    return _this;
	  }

	  _createClass(OAuth2Provider, [{
	    key: "connected",
	    value: function connected() {
	      this.required('clientID', 'responseType');
	    }
	  }, {
	    key: "secure",
	    value: function () {
	      var _secure = _asyncToGenerator( /*#__PURE__*/regenerator.mark(function _callee(request) {
	        return regenerator.wrap(function _callee$(_context) {
	          while (1) {
	            switch (_context.prev = _context.next) {
	              case 0:
	                if (!(this.config.responseType === 'token')) {
	                  _context.next = 13;
	                  break;
	                }

	                if (!this.accessToken.expired) {
	                  _context.next = 3;
	                  break;
	                }

	                return _context.abrupt("return", 'login');

	              case 3:
	                if (!request) {
	                  _context.next = 13;
	                  break;
	                }

	                if (!(request instanceof Request)) {
	                  _context.next = 8;
	                  break;
	                }

	                request.headers.set('Authorization', "Bearer ".concat(this.accessToken.raw));
	                _context.next = 13;
	                break;

	              case 8:
	                if (!(request instanceof XMLHttpRequest)) {
	                  _context.next = 12;
	                  break;
	                }

	                request.setRequestHeader('Authorization', "Bearer ".concat(this.accessToken.raw));
	                _context.next = 13;
	                break;

	              case 12:
	                throw new SalteAuthError({
	                  code: 'unknown_request',
	                  message: "Unknown request type. (".concat(request, ")")
	                });

	              case 13:
	                return _context.abrupt("return", true);

	              case 14:
	              case "end":
	                return _context.stop();
	            }
	          }
	        }, _callee, this);
	      }));

	      function secure(_x) {
	        return _secure.apply(this, arguments);
	      }

	      return secure;
	    }()
	  }, {
	    key: "$validate",
	    value: function $validate(options) {
	      try {
	        if (!options) {
	          throw new SalteAuthError({
	            code: 'empty_response',
	            message: "The response provided was empty, this is most likely due to the configured handler not providing it."
	          });
	        }

	        if (options.error) {
	          throw new SalteAuthError({
	            code: options.error,
	            message: "".concat(options.error_description ? options.error_description : options.error).concat(options.error_uri ? " (".concat(options.error_uri, ")") : '')
	          });
	        }

	        var _code = options.code,
	            access_token = options.access_token,
	            state = options.state,
	            expires_in = options.expires_in,
	            token_type = options.token_type;

	        if (this.validation('state') && this.storage.get('state') !== state) {
	          throw new SalteAuthError({
	            code: 'invalid_state',
	            message: 'State provided by identity provider did not match local state.'
	          });
	        }

	        var types = this.storage.get('response-type', '').split(' ');

	        if (Common.includes(types, 'code')) {
	          if (!_code) {
	            throw new SalteAuthError({
	              code: 'invalid_code',
	              message: 'Expected a code to be returned by the Provider.'
	            });
	          }
	        } else if (Common.includes(types, 'token')) {
	          if (!access_token) {
	            throw new SalteAuthError({
	              code: 'invalid_access_token',
	              message: 'Expected an access token to be returned by the Provider.'
	            });
	          }
	        }

	        if (_code) {
	          this.storage.set('code.raw', _code);
	          this.storage.delete('access-token.raw');
	          this.storage.delete('access-token.expiration');
	          this.storage.delete('access-token.type');
	        } else if (access_token) {
	          this.storage.set('access-token.raw', access_token);
	          this.storage.set('access-token.expiration', Date.now() + Number(expires_in) * 1000);
	          this.storage.set('access-token.type', token_type);
	          this.storage.delete('code.raw');
	        }
	      } finally {
	        this.storage.delete('state');
	      }
	    }
	  }, {
	    key: "validate",
	    value: function validate(options) {
	      this.logger.trace('[validate] (options): ', options);

	      try {
	        this.$validate(options);
	      } catch (error) {
	        this.emit('login', error);
	        throw error;
	      } finally {
	        this.sync();
	      }

	      this.emit('login', null, this.code || this.accessToken);
	    }
	  }, {
	    key: "code",
	    get: function get() {
	      return this.storage.get('code.raw');
	    }
	  }, {
	    key: "$login",
	    value: function $login() {
	      var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
	      var state = "".concat(this.$name, "-state-").concat(index_browser());
	      var responseType = options.responseType || this.config.responseType;
	      this.storage.set('state', state);
	      this.storage.set('response-type', responseType);
	      return this.url(this.login, _objectSpread(_objectSpread({}, this.config.queryParams && this.config.queryParams('login')), {}, {
	        client_id: this.config.clientID,
	        response_type: responseType,
	        redirect_uri: this.redirectUrl('login'),
	        scope: this.config.scope,
	        state: state
	      }));
	    }
	  }, {
	    key: "sync",
	    value: function sync() {
	      this.logger.trace('[sync] updating access token');
	      this.accessToken = new AccessToken(this.storage.get('access-token.raw'), this.storage.get('access-token.expiration'), this.storage.get('access-token.type'));
	    }
	  }]);

	  return OAuth2Provider;
	}(Provider);

	var superPropBase = createCommonjsModule(function (module) {
	function _superPropBase(object, property) {
	  while (!Object.prototype.hasOwnProperty.call(object, property)) {
	    object = getPrototypeOf(object);
	    if (object === null) break;
	  }

	  return object;
	}

	module.exports = _superPropBase;
	module.exports["default"] = module.exports, module.exports.__esModule = true;
	});

	unwrapExports(superPropBase);

	var get = createCommonjsModule(function (module) {
	function _get(target, property, receiver) {
	  if (typeof Reflect !== "undefined" && Reflect.get) {
	    module.exports = _get = Reflect.get;
	    module.exports["default"] = module.exports, module.exports.__esModule = true;
	  } else {
	    module.exports = _get = function _get(target, property, receiver) {
	      var base = superPropBase(target, property);
	      if (!base) return;
	      var desc = Object.getOwnPropertyDescriptor(base, property);

	      if (desc.get) {
	        return desc.get.call(receiver);
	      }

	      return desc.value;
	    };

	    module.exports["default"] = module.exports, module.exports.__esModule = true;
	  }

	  return _get(target, property, receiver || target);
	}

	module.exports = _get;
	module.exports["default"] = module.exports, module.exports.__esModule = true;
	});

	var _get = unwrapExports(get);

	function _createSuper$3(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$3(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

	function _isNativeReflectConstruct$3() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
	var OpenIDProvider = /*#__PURE__*/function (_OAuth2Provider) {
	  _inherits(OpenIDProvider, _OAuth2Provider);

	  var _super = _createSuper$3(OpenIDProvider);

	  function OpenIDProvider(config) {
	    var _this;

	    _classCallCheck(this, OpenIDProvider);

	    _this = _super.call(this, config);

	    _defineProperty(_assertThisInitialized(_this), "idToken", void 0);

	    _this.config.renewal = _typeof(_this.config.renewal) === 'object' ? _this.config.renewal : {
	      type: _this.config.renewal
	    };
	    _this.config = Common.defaults(_this.config, {
	      responseType: 'id_token',
	      scope: 'openid',
	      renewal: {
	        type: 'auto',
	        buffer: 60000
	      }
	    });

	    _this.sync();

	    return _this;
	  }

	  _createClass(OpenIDProvider, [{
	    key: "secure",
	    value: function () {
	      var _secure = _asyncToGenerator( /*#__PURE__*/regenerator.mark(function _callee2(request) {
	        var _this2 = this;

	        return regenerator.wrap(function _callee2$(_context2) {
	          while (1) {
	            switch (_context2.prev = _context2.next) {
	              case 0:
	                if (!Common.includes(['id_token', 'id_token token', 'token'], this.config.responseType)) {
	                  _context2.next = 17;
	                  break;
	                }

	                if (!this.idToken.expired) {
	                  _context2.next = 4;
	                  break;
	                }

	                this.logger.trace('[secure]: ID Token has expired, requesting login...');
	                return _context2.abrupt("return", 'login');

	              case 4:
	                if (!this.accessToken.expired) {
	                  _context2.next = 7;
	                  break;
	                }

	                _context2.next = 7;
	                return this.dedupe('access-token', /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regenerator.mark(function _callee() {
	                  var parsed;
	                  return regenerator.wrap(function _callee$(_context) {
	                    while (1) {
	                      switch (_context.prev = _context.next) {
	                        case 0:
	                          _this2.logger.info("[secure]: Expired access token detected, retrieving...");

	                          _context.next = 3;
	                          return Common.iframe({
	                            redirectUrl: _this2.redirectUrl('login'),
	                            url: _this2.$login({
	                              prompt: 'none',
	                              responseType: 'token'
	                            })
	                          });

	                        case 3:
	                          parsed = _context.sent;

	                          _this2.logger.info("[secure]: Access token retrieved! Validating...");

	                          _this2.validate(parsed);

	                        case 6:
	                        case "end":
	                          return _context.stop();
	                      }
	                    }
	                  }, _callee);
	                })));

	              case 7:
	                if (!request) {
	                  _context2.next = 17;
	                  break;
	                }

	                if (!(request instanceof Request)) {
	                  _context2.next = 12;
	                  break;
	                }

	                request.headers.set('Authorization', "Bearer ".concat(this.accessToken.raw));
	                _context2.next = 17;
	                break;

	              case 12:
	                if (!(request instanceof XMLHttpRequest)) {
	                  _context2.next = 16;
	                  break;
	                }

	                request.setRequestHeader('Authorization', "Bearer ".concat(this.accessToken.raw));
	                _context2.next = 17;
	                break;

	              case 16:
	                throw new SalteAuthError({
	                  code: 'unknown_request',
	                  message: "Unknown request type. (".concat(request, ")")
	                });

	              case 17:
	                return _context2.abrupt("return", true);

	              case 18:
	              case "end":
	                return _context2.stop();
	            }
	          }
	        }, _callee2, this);
	      }));

	      function secure(_x) {
	        return _secure.apply(this, arguments);
	      }

	      return secure;
	    }()
	  }, {
	    key: "$validate",
	    value: function $validate(options) {
	      try {
	        _get(_getPrototypeOf(OpenIDProvider.prototype), "$validate", this).call(this, options);

	        var id_token = options.id_token,
	            code = options.code;

	        if (id_token) {
	          var _id_token = options.id_token;
	          var user = IDToken.parse(_id_token);

	          if (!user) {
	            throw new SalteAuthError({
	              code: 'invalid_id_token',
	              message: 'Failed to parse user information due to invalid id token.'
	            });
	          }

	          if (this.validation('nonce') && this.storage.get('nonce') !== user.nonce) {
	            throw new SalteAuthError({
	              code: 'invalid_nonce',
	              message: 'Nonce provided by identity provider did not match the local nonce.'
	            });
	          }

	          this.storage.set('id-token.raw', _id_token);
	        } else if (code) {
	          this.storage.delete('id-token.raw');
	        }
	      } finally {
	        this.storage.delete('nonce');
	      }
	    }
	  }, {
	    key: "validate",
	    value: function validate(options) {
	      this.logger.trace('[validate] (options): ', options);

	      try {
	        this.$validate(options);
	      } catch (error) {
	        this.emit('login', error);
	        throw error;
	      } finally {
	        this.sync();
	      }

	      var responseType = this.storage.get('response-type', '');
	      var types = responseType.split(' ');

	      if (Common.includes(types, 'id_token')) {
	        this.emit('login', null, this.idToken);
	      } else if (Common.includes(types, 'token')) {
	        this.emit('login', null, this.accessToken);
	      } else if (Common.includes(types, 'code')) {
	        this.emit('login', null, this.code);
	      } else {
	        throw new SalteAuthError({
	          code: 'invalid_response_type',
	          message: "Unknown Response Type (".concat(responseType, ")")
	        });
	      }
	    }
	  }, {
	    key: "$login",
	    value: function $login(options) {
	      var nonce = "".concat(this.$name, "-nonce-").concat(index_browser());
	      this.storage.set('nonce', nonce);
	      return this.url(_get(_getPrototypeOf(OpenIDProvider.prototype), "$login", this).call(this, options), {
	        prompt: options && options.prompt,
	        nonce: nonce
	      });
	    }
	  }, {
	    key: "sync",
	    value: function sync() {
	      _get(_getPrototypeOf(OpenIDProvider.prototype), "sync", this).call(this);

	      this.logger.trace('[sync] updating id token');
	      this.idToken = new IDToken(this.storage.get('id-token.raw'));
	    }
	  }]);

	  return OpenIDProvider;
	}(OAuth2Provider);

	function _createSuper$2(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$2(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

	function _isNativeReflectConstruct$2() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
	var OAuth2 = /*#__PURE__*/function (_OAuth2Provider) {
	  _inherits(OAuth2, _OAuth2Provider);

	  var _super = _createSuper$2(OAuth2);

	  function OAuth2(config) {
	    var _this;

	    _classCallCheck(this, OAuth2);

	    _this = _super.call(this, config);

	    _this.required('login');

	    return _this;
	  }

	  _createClass(OAuth2, [{
	    key: "name",
	    get: function get() {
	      return 'generic.oauth2';
	    }
	  }, {
	    key: "login",
	    get: function get() {
	      return this.config.login.apply(this);
	    }
	  }]);

	  return OAuth2;
	}(OAuth2Provider);
	var OpenID = /*#__PURE__*/function (_OpenIDProvider) {
	  _inherits(OpenID, _OpenIDProvider);

	  var _super2 = _createSuper$2(OpenID);

	  function OpenID(config) {
	    var _this2;

	    _classCallCheck(this, OpenID);

	    _this2 = _super2.call(this, config);

	    _this2.required('login', 'logout');

	    return _this2;
	  }

	  _createClass(OpenID, [{
	    key: "name",
	    get: function get() {
	      return 'generic.openid';
	    }
	  }, {
	    key: "login",
	    get: function get() {
	      return this.config.login.apply(this);
	    }
	  }, {
	    key: "logout",
	    get: function get() {
	      return this.config.logout.apply(this);
	    }
	  }]);

	  return OpenID;
	}(OpenIDProvider);

	var generic = /*#__PURE__*/Object.freeze({
		__proto__: null,
		OAuth2: OAuth2,
		OpenID: OpenID
	});

	function _createSuper$1(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

	function _isNativeReflectConstruct$1() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
	var Handler = /*#__PURE__*/function (_Storage) {
	  _inherits(Handler, _Storage);

	  var _super = _createSuper$1(Handler);

	  function Handler(config) {
	    var _this;

	    _classCallCheck(this, Handler);

	    _this = _super.call(this, config);

	    _defineProperty(_assertThisInitialized(_this), "logger", void 0);

	    _this.config = Common.defaults(_this.config, {
	      navigate: 'reload',
	      level: 'warn'
	    });
	    _this.logger = new Logger("@salte-auth/salte-auth:handlers/".concat(_this.$name), _this.config.level);
	    return _this;
	  }
	  /**
	   * The unique name of the handler
	   */


	  _createClass(Handler, [{
	    key: "$name",
	    get: function get() {
	      return this.config.name || this.name;
	    }
	  }, {
	    key: "key",
	    get: function get() {
	      return "salte.auth.handler.".concat(this.$name);
	    }
	    /**
	     * Navigates to the url provided.
	     * @param url - the url to navigate to
	     */

	    /* istanbul ignore next */

	  }, {
	    key: "navigate",
	    value: function navigate(url) {
	      if (this.config.navigate === 'history' && url.indexOf(URL.origin) === 0) {
	        history.pushState('', document.title, url);
	      }

	      location.href = url;
	    }
	  }]);

	  return Handler;
	}(Storage);

	function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

	function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
	var SalteAuth = /*#__PURE__*/function (_Shared) {
	  _inherits(SalteAuth, _Shared);

	  var _super = _createSuper(SalteAuth);

	  function SalteAuth(config) {
	    var _this;

	    _classCallCheck(this, SalteAuth);

	    _this = _super.call(this, config);

	    _defineProperty(_assertThisInitialized(_this), "logger", void 0);

	    _defineProperty(_assertThisInitialized(_this), "mixin", void 0);

	    _this.required('providers', 'handlers');

	    _this.config = Common.defaults(_this.config, {
	      validation: true,
	      level: 'warn'
	    });
	    _this.logger = new Logger("@salte-auth/salte-auth:core", _this.config.level);
	    Common.forEach(_this.config.providers, function (provider) {
	      provider.connected && provider.connected();
	      provider.on('login', function (error, data) {
	        _this.emit('login', error, {
	          provider: provider.$name,
	          data: data
	        });
	      });
	      provider.on('logout', function (error) {
	        _this.emit('logout', error, {
	          provider: provider.$name
	        });
	      });
	    });

	    var action = _this.storage.get('action');

	    var provider = action ? _this.provider(_this.storage.get('provider')) : null;
	    var handlerName = action ? _this.storage.get('handler') : null;

	    if (!Common.includes([undefined, null, 'login', 'logout'], action)) {
	      throw new SalteAuthError({
	        code: 'unknown_action',
	        message: "Unable to finish redirect due to an unknown action! (".concat(action, ")")
	      });
	    }

	    Common.forEach(_this.config.handlers, function (handler) {
	      if (!handler.connected) return;
	      var responsible = handler.$name === handlerName;

	      if (responsible) {
	        provider.dedupe(action, /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regenerator.mark(function _callee() {
	          var parsed;
	          return regenerator.wrap(function _callee$(_context) {
	            while (1) {
	              switch (_context.prev = _context.next) {
	                case 0:
	                  _this.logger.trace("[constructor]: wrapping up authentication for ".concat(handler.$name, "..."));

	                  _context.next = 3;
	                  return new Promise(function (resolve) {
	                    return setTimeout(resolve);
	                  });

	                case 3:
	                  parsed = handler.connected({
	                    action: action
	                  });

	                  if (action === 'login') {
	                    provider.validate(parsed);

	                    _this.logger.info('[constructor]: login complete');
	                  } else {
	                    provider.storage.clear();
	                    provider.sync();
	                    provider.emit('logout');

	                    _this.logger.info('[constructor]: logout complete');
	                  }

	                case 5:
	                case "end":
	                  return _context.stop();
	              }
	            }
	          }, _callee);
	        })));
	      } else {
	        handler.connected({
	          action: null
	        });
	      }
	    });

	    _this.storage.delete('action');

	    _this.storage.delete('provider');

	    _this.storage.delete('handler');

	    Fetch.add( /*#__PURE__*/function () {
	      var _ref2 = _asyncToGenerator( /*#__PURE__*/regenerator.mark(function _callee2(request) {
	        var i, _provider;

	        return regenerator.wrap(function _callee2$(_context2) {
	          while (1) {
	            switch (_context2.prev = _context2.next) {
	              case 0:
	                i = 0;

	              case 1:
	                if (!(i < _this.config.providers.length)) {
	                  _context2.next = 9;
	                  break;
	                }

	                _provider = _this.config.providers[i];

	                if (!URL.match(request.url, _provider.config.endpoints)) {
	                  _context2.next = 6;
	                  break;
	                }

	                _context2.next = 6;
	                return _this.$secure(_provider, request);

	              case 6:
	                i++;
	                _context2.next = 1;
	                break;

	              case 9:
	              case "end":
	                return _context2.stop();
	            }
	          }
	        }, _callee2);
	      }));

	      return function (_x) {
	        return _ref2.apply(this, arguments);
	      };
	    }());
	    XHR.add( /*#__PURE__*/function () {
	      var _ref3 = _asyncToGenerator( /*#__PURE__*/regenerator.mark(function _callee3(request) {
	        var i, _provider2;

	        return regenerator.wrap(function _callee3$(_context3) {
	          while (1) {
	            switch (_context3.prev = _context3.next) {
	              case 0:
	                i = 0;

	              case 1:
	                if (!(i < _this.config.providers.length)) {
	                  _context3.next = 9;
	                  break;
	                }

	                _provider2 = _this.config.providers[i];

	                if (!URL.match(request.$url, _provider2.config.endpoints)) {
	                  _context3.next = 6;
	                  break;
	                }

	                _context3.next = 6;
	                return _this.$secure(_provider2, request);

	              case 6:
	                i++;
	                _context3.next = 1;
	                break;

	              case 9:
	              case "end":
	                return _context3.stop();
	            }
	          }
	        }, _callee3);
	      }));

	      return function (_x2) {
	        return _ref3.apply(this, arguments);
	      };
	    }());
	    Events$1.route( /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regenerator.mark(function _callee4() {
	      var i, _provider3;

	      return regenerator.wrap(function _callee4$(_context4) {
	        while (1) {
	          switch (_context4.prev = _context4.next) {
	            case 0:
	              i = 0;

	            case 1:
	              if (!(i < _this.config.providers.length)) {
	                _context4.next = 9;
	                break;
	              }

	              _provider3 = _this.config.providers[i];

	              if (!URL.match(location.href, _provider3.config.routes)) {
	                _context4.next = 6;
	                break;
	              }

	              _context4.next = 6;
	              return _this.$secure(_provider3);

	            case 6:
	              i++;
	              _context4.next = 1;
	              break;

	            case 9:
	            case "end":
	              return _context4.stop();
	          }
	        }
	      }, _callee4);
	    })));
	    _this.mixin = AuthMixinGenerator(_assertThisInitialized(_this));
	    return _this;
	  }
	  /**
	   * Login to the specified provider.
	   *
	   * @param options - the authentication options
	   */


	  _createClass(SalteAuth, [{
	    key: "login",
	    value: function () {
	      var _login = _asyncToGenerator( /*#__PURE__*/regenerator.mark(function _callee6(options) {
	        var _this2 = this;

	        var normalizedOptions, provider;
	        return regenerator.wrap(function _callee6$(_context6) {
	          while (1) {
	            switch (_context6.prev = _context6.next) {
	              case 0:
	                normalizedOptions = typeof options === 'string' ? {
	                  provider: options
	                } : options;
	                provider = this.provider(normalizedOptions.provider);
	                return _context6.abrupt("return", provider.dedupe('login', /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regenerator.mark(function _callee5() {
	                  var handler, params;
	                  return regenerator.wrap(function _callee5$(_context5) {
	                    while (1) {
	                      switch (_context5.prev = _context5.next) {
	                        case 0:
	                          handler = _this2.handler(normalizedOptions.handler);
	                          _context5.prev = 1;

	                          _this2.storage.set('action', 'login');

	                          _this2.storage.set('provider', provider.$name);

	                          _this2.storage.set('handler', handler.$name);

	                          _this2.logger.info("[login]: logging in with ".concat(provider.$name, " via ").concat(handler.$name, "..."));

	                          _context5.next = 8;
	                          return handler.open({
	                            redirectUrl: provider.redirectUrl('login'),
	                            url: provider.$login()
	                          });

	                        case 8:
	                          params = _context5.sent;

	                          _this2.logger.trace("[login]: validating response...", params);

	                          provider.validate(params);

	                          _this2.logger.info('[login]: login complete');

	                        case 12:
	                          _context5.prev = 12;

	                          _this2.storage.delete('action');

	                          _this2.storage.delete('provider');

	                          _this2.storage.delete('handler');

	                          return _context5.finish(12);

	                        case 17:
	                        case "end":
	                          return _context5.stop();
	                      }
	                    }
	                  }, _callee5, null, [[1,, 12, 17]]);
	                }))));

	              case 3:
	              case "end":
	                return _context6.stop();
	            }
	          }
	        }, _callee6, this);
	      }));

	      function login(_x3) {
	        return _login.apply(this, arguments);
	      }

	      return login;
	    }()
	    /**
	     * Logout of the specified provider.
	     *
	     * @param options - the authentication options
	     */

	  }, {
	    key: "logout",
	    value: function () {
	      var _logout = _asyncToGenerator( /*#__PURE__*/regenerator.mark(function _callee8(options) {
	        var _this3 = this;

	        var normalizedOptions, provider;
	        return regenerator.wrap(function _callee8$(_context8) {
	          while (1) {
	            switch (_context8.prev = _context8.next) {
	              case 0:
	                normalizedOptions = typeof options === 'string' ? {
	                  provider: options
	                } : options;
	                provider = this.provider(normalizedOptions.provider);
	                return _context8.abrupt("return", provider.dedupe('logout', /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regenerator.mark(function _callee7() {
	                  var handler;
	                  return regenerator.wrap(function _callee7$(_context7) {
	                    while (1) {
	                      switch (_context7.prev = _context7.next) {
	                        case 0:
	                          _context7.prev = 0;
	                          handler = _this3.handler(normalizedOptions.handler);

	                          _this3.storage.set('action', 'logout');

	                          _this3.storage.set('provider', provider.$name);

	                          _this3.storage.set('handler', handler.$name);

	                          _this3.logger.info("[logout]: logging out with ".concat(provider.$name, " via ").concat(handler.$name, "..."));

	                          _context7.next = 8;
	                          return handler.open({
	                            redirectUrl: provider.redirectUrl('logout'),
	                            url: URL.url(provider.logout, provider.config.queryParams && provider.config.queryParams('logout'))
	                          });

	                        case 8:
	                          provider.storage.clear();
	                          provider.sync();
	                          provider.emit('logout');

	                          _this3.logger.info('[logout]: logout complete');

	                          _context7.next = 18;
	                          break;

	                        case 14:
	                          _context7.prev = 14;
	                          _context7.t0 = _context7["catch"](0);
	                          provider.emit('logout', _context7.t0);
	                          throw _context7.t0;

	                        case 18:
	                          _context7.prev = 18;

	                          _this3.storage.delete('action');

	                          _this3.storage.delete('provider');

	                          _this3.storage.delete('handler');

	                          return _context7.finish(18);

	                        case 23:
	                        case "end":
	                          return _context7.stop();
	                      }
	                    }
	                  }, _callee7, null, [[0, 14, 18, 23]]);
	                }))));

	              case 3:
	              case "end":
	                return _context8.stop();
	            }
	          }
	        }, _callee8, this);
	      }));

	      function logout(_x4) {
	        return _logout.apply(this, arguments);
	      }

	      return logout;
	    }()
	    /**
	     * Returns a provider that matches the given name.
	     * @param name - the name of the provider
	     * @returns the provider with the given name.
	     */

	  }, {
	    key: "provider",
	    value: function provider(name) {
	      var provider = Common.find(this.config.providers, function (provider) {
	        return provider.$name === name;
	      });

	      if (!provider) {
	        throw new SalteAuthError({
	          code: 'invalid_provider',
	          message: "Unable to locate provider with the given name. (".concat(name, ")")
	        });
	      }

	      return provider;
	    }
	    /**
	     * Returns a handler that matches the given name.
	     * @param name - the name of the handler
	     * @returns the handler with the given name, if no name is specified then the default handler.
	     */

	  }, {
	    key: "handler",
	    value: function handler(name) {
	      var handler = name === undefined ? Common.find(this.config.handlers, function (handler) {
	        return Boolean(handler.config.default);
	      }) : Common.find(this.config.handlers, function (handler) {
	        return handler.$name === name;
	      });

	      if (!handler) {
	        throw new SalteAuthError({
	          code: 'invalid_handler',
	          message: "Unable to locate handler with the given name. (".concat(name, ")")
	        });
	      }

	      return handler;
	    }
	  }, {
	    key: "$secure",
	    value: function () {
	      var _$secure = _asyncToGenerator( /*#__PURE__*/regenerator.mark(function _callee9(provider, request) {
	        var handler, response;
	        return regenerator.wrap(function _callee9$(_context9) {
	          while (1) {
	            switch (_context9.prev = _context9.next) {
	              case 0:
	                handler = this.handler();
	                response = null;

	              case 2:
	                if (!(response !== true)) {
	                  _context9.next = 13;
	                  break;
	                }

	                _context9.next = 5;
	                return provider.secure(request);

	              case 5:
	                response = _context9.sent;

	                if (!(response === 'login')) {
	                  _context9.next = 11;
	                  break;
	                }

	                if (handler.auto) {
	                  _context9.next = 9;
	                  break;
	                }

	                throw new SalteAuthError({
	                  code: 'auto_unsupported',
	                  message: "The default handler doesn't support automatic authentication! (".concat(handler.$name, ")")
	                });

	              case 9:
	                _context9.next = 11;
	                return this.login({
	                  provider: provider.$name,
	                  handler: handler.$name
	                });

	              case 11:
	                _context9.next = 2;
	                break;

	              case 13:
	              case "end":
	                return _context9.stop();
	            }
	          }
	        }, _callee9, this);
	      }));

	      function $secure(_x5, _x6) {
	        return _$secure.apply(this, arguments);
	      }

	      return $secure;
	    }()
	  }]);

	  return SalteAuth;
	}(Shared);

	exports.Generic = generic;
	exports.Handler = Handler;
	exports.OAuth2Provider = OAuth2Provider;
	exports.OpenIDProvider = OpenIDProvider;
	exports.Provider = Provider;
	exports.SalteAuth = SalteAuth;
	exports.SalteAuthError = SalteAuthError;
	exports.Utils = index;

	Object.defineProperty(exports, '__esModule', { value: true });

})));
//# sourceMappingURL=salte-auth.js.map
