export declare class Dedupe {
    static dedupe(): Dedupe.Function;
}
export declare namespace Dedupe {
    /**
     * Prevents multiple active promises for a given key.
     * @param key - The key to dedupe
     * @param fn - A function that resolves to a promise.
     */
    type Function = <T>(key: string, fn: () => Promise<T>) => Promise<T>;
}
