export declare class IDToken {
    raw: string;
    user: IDToken.UserInfo;
    constructor(idToken: string);
    get expired(): boolean;
    static parse(idToken?: string): IDToken.UserInfo | null;
}
export declare namespace IDToken {
    interface UserInfo {
        [key: string]: any;
        /**
         * Issuer Identifier for the Issuer of the response.
         */
        iss: string;
        /**
         * A locally unique and never reassigned identifier within the Provider for the End-User.
         */
        sub: string;
        /**
         * Audience(s) that this ID Token is intended for.
         */
        aud: string[];
        /**
         * Value used to mitigate replay attacks by associating a client session with an id_token.
         */
        nonce: string;
        /**
         * Expiration time on or after which the ID Token MUST NOT be accepted for processing.
         *
         * Represented as a unix epoch timestamp (seconds)
         */
        exp: number;
        /**
         * When the JWT was issued.
         *
         * Represented as a unix epoch timestamp (seconds)
         */
        iat: number;
    }
}
