import { Storage } from './storage';
export declare class CookieStorage extends Storage {
    /**
     * Determines if the current browser allows cookies.
     * @returns true if cookies aren't disabled.
     */
    static supported(): boolean;
    get(name: string, defaultValue?: string): string;
    set(name: string, value: any): void;
    delete(name: string): void;
    clear(): void;
}
