export declare abstract class Storage {
    protected baseKey: string;
    constructor(baseKey?: string);
    /**
     * Determines if the current browser supports this storage type.
     * @returns true if the storage type is supported
     */
    static supported(): boolean;
    has(name: string): boolean;
    /**
     * Returns a scoped key for storage.
     * @param key - The storage key.
     *
     * @example Storage.key('hello') // 'salte.auth.handler.redirect.hello'
     */
    protected key(key?: string): string;
}
export interface Storage {
    get(name: string, defaultValue?: string): string | null;
    set(name: string, value: any): void;
    delete(name: string): void;
    clear(): void;
}
