export declare class URL {
    /**
     * Outputs a result equivalent to `location.origin`
     */
    static get origin(): string;
    static resolve(path: string): string;
    static match(url: string, tests: (string | RegExp)[] | boolean): boolean;
    static parse({ search, hash }: Location): any;
    /**
     * Creates a url with the given query parameters
     * @param base - the base url without query parameters
     * @param params - the query parameters to attache to the url
     * @returns the built url
     */
    static url(base: string, params?: {
        [key: string]: any;
    }): string;
}
