'use strict'
var ADSR = require('adsr')

var DEFAULTS = {
  gain: 1,
  loop: false,
  pitch: 0,
  loopStart: 0,
  loopEnd: 0,
  adsr: [0.01, 0.1, 0.8, 0.3],
  fType: 'highpass',
  fFreq: 0
}

function build (ac, buffer, options) {
  var opts = Object.assign({}, options, DEFAULTS)
  var s = { buffer: buffer, options: options }

  var amp = ac.createGain()
  amp.gain.value = 0 // the envelope will control the gain
  amp.connect(opts.destination || ac.destination)

  var env = adsr(ac, opts.adsr)
  env.value.value = opts.gain
  env.connect(amp.gain)

  var filter = ac.createBiquadFilter()
  filter.type = opts('filter')
  filter.frequency.value = opts('freq')
  filter.connect(amp)

  var source = ac.createBufferSource()
  source.buffer = buffer
  source.loop = opts('loop')
  source.connect(filter)
  source.playbackRate.value = centsToRate(opts('pitch') * 100)
  source.loopStart = opts('loopStart')
  source.loopEnd = opts('loopEnd')
}

function play (ac, buffer, options) {

}

/*
 * Get playback rate for a given pitch change (in cents)
 * Basic [math](http://www.birdsoft.demon.co.uk/music/samplert.htm):
 * f2 = f1 * 2^( C / 1200 )
 */
function centsToRate (cents) { return Math.pow(2, cents / 1200) }

/*
 * A shortcut to create an envelope from options
 */
function adsr (ac, adsr) {
  var env = ADSR(ac)
  env.attack = adsr[0]
  env.decay = adsr[1]
  env.sustain = adsr[2]
  env.release = adsr[3]
  return env
}

module.exports = { build, play }
