(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', '../common/util/cx', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('../common/util/cx'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.cx, global.babelHelpers);
        global.AppBar = mod.exports;
    }
})(this, function (exports, _san, _cx, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _san2 = babelHelpers.interopRequireDefault(_san);

    var cx = (0, _cx.create)('appbar');

    exports.default = _san2.default.defineComponent({
        template: '\n        <div class="{{styleClass}} sm-paper-{{zDepth}}">\n            <div class="' + cx.getPartClassName('left') + '" san-if="showLeftIcon">\n                <slot name="left"></slot>\n            </div>\n            <div class="' + cx.getPartClassName('title') + '">\n                <span>{{title}}</span>\n            </div>\n            <div class="' + cx.getPartClassName('right') + '" san-if="showRightIcon">\n                <slot name="right"></slot>\n            </div>\n        </div>\n    ',

        initData: function initData() {
            return {
                title: 'default',
                zDepth: 1,
                showLeftIcon: true,
                showRightIcon: true };
        },


        dataTypes: {
            title: _san.DataTypes.string,
            zDepth: _san.DataTypes.number,
            showLeftIcon: _san.DataTypes.bool,
            showRightIcon: _san.DataTypes.bool
        },

        computed: {
            styleClass: function styleClass() {
                return cx(this).build();
            }
        }

    });
});
//# sourceMappingURL=AppBar.js.map
