(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', '../Icon/index', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('../Icon/index'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.index, global.babelHelpers);
        global.Avatar = mod.exports;
    }
})(this, function (exports, _san, _index, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _san2 = babelHelpers.interopRequireDefault(_san);

    var _index2 = babelHelpers.interopRequireDefault(_index);

    exports.default = _san2.default.defineComponent({

        template: '\n        <div class="sm-avatar" style="{{avatarStyleDefault}} {{avatarStyle}}">\n            <san-icon san-if="{{icon}}">{{icon}}</san-icon>\n            <slot></slot>\n        </div>\n    ',

        components: {
            'san-icon': _index2.default
        },

        initData: function initData() {
            return {
                'size': 40,
                'iconSize': 20,
                'background-color': '#bdbdbd',
                'color': '#f93',
                'src': ''
            };
        },


        dataTypes: {
            size: _san.DataTypes.number,
            iconSize: _san.DataTypes.number,
            backgroundColor: _san.DataTypes.string,
            color: _san.DataTypes.string,
            src: _san.DataTypes.string
        },

        computed: {
            avatarStyleDefault: function avatarStyleDefault() {
                var size = this.data.get('size') + 'px';
                var style = {
                    'background-color': this.data.get('backgroundColor'),
                    'color': this.data.get('color'),
                    'font-size': this.data.get('iconSize'),
                    'width': size,
                    'height': size,
                    'line-height': size
                };

                if (this.data.get('src')) {
                    Object.assign(style, {
                        'background-image': 'url(' + this.data.get('src') + ')'
                    });
                }

                return style;
            }
        }
    });
});
//# sourceMappingURL=Avatar.js.map
