(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', '../common/util/cx', 'san', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('../common/util/cx'), require('san'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.cx, global.san, global.babelHelpers);
        global.Badge = mod.exports;
    }
})(this, function (exports, _cx, _san, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _san2 = babelHelpers.interopRequireDefault(_san);

    var cx = (0, _cx.create)('badge');

    exports.default = _san2.default.defineComponent({

        template: '\n        <div class="{{computedClass}}">\n            <em\n                san-if="content"\n                class="' + cx.getPartClassName('inform-default') + '"\n                style="{{computedStyleDefault}}">\n                {{computedContent}}\n            </em>\n            <div\n                class="' + cx.getPartClassName('inform') + '"\n                style="{{computedStyleIcon}}">\n                <slot name="content"></slot>\n            </div>\n            <div class="' + cx.getPartClassName('text-wrapper') + '">\n                <slot></slot>\n            </div>\n        </div>\n    ',

        initData: function initData() {
            return {
                content: '',
                hidden: false,
                color: ''
            };
        },


        dataTypes: {
            content: _san.DataTypes.oneOfType([_san.DataTypes.string, _san.DataTypes.number]),
            hidden: _san.DataTypes.bool,
            max: _san.DataTypes.number,
            color: _san.DataTypes.string
        },

        computed: {
            computedClass: function computedClass() {
                return cx(this).build();
            },
            computedContent: function computedContent() {
                var max = this.data.get('max');
                var content = this.data.get('content');
                return content != null && max != null && +content > max ? max + '+' : content;
            },
            computedStyleDefault: function computedStyleDefault() {
                var color = this.data.get('color');
                var ifShow = this.data.get('hidden') ? 'none' : 'block';
                return {
                    'background-color': color,
                    'display': ifShow
                };
            },
            computedStyleIcon: function computedStyleIcon() {
                var color = this.data.get('color');
                var ifShow = this.data.get('hidden') ? 'none' : 'block';
                return {
                    color: color,
                    display: ifShow
                };
            }
        }

    });
});
//# sourceMappingURL=Badge.js.map
