(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.babelHelpers);
        global.Base = mod.exports;
    }
})(this, function (exports, _san, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });


    var linkANodeProps = (0, _san.parseTemplate)('<a href="{{href}}" target="{{target}}"/>').children[0].props;

    var hrefProps = void 0;
    var targetProps = void 0;
    linkANodeProps.map(function (item) {
        if (item.name === 'href') {
            hrefProps = item;
        } else if (item.name === 'target') {
            targetProps = item;
        }
        return item;
    });

    var BaseButton = function (_Component) {
        babelHelpers.inherits(BaseButton, _Component);

        function BaseButton() {
            babelHelpers.classCallCheck(this, BaseButton);
            return babelHelpers.possibleConstructorReturn(this, (BaseButton.__proto__ || Object.getPrototypeOf(BaseButton)).apply(this, arguments));
        }

        babelHelpers.createClass(BaseButton, [{
            key: 'inited',
            value: function inited() {
                var data = this.data,
                    aNode = this.aNode;

                if (data.get('href')) {
                    aNode.tagName = 'A';
                    aNode.props.push(hrefProps);
                    aNode.props = aNode.props.filter(function (item) {
                        return item.name && item.name !== 'type';
                    });
                    aNode.props.splice(0, 1);
                    this.tagName = 'a';
                }

                if (data.get('target')) {
                    aNode.props.push(targetProps);
                }
            }
        }, {
            key: 'initData',
            value: function initData() {
                return {
                    type: 'button',
                    disabled: false
                };
            }
        }]);
        return BaseButton;
    }(_san.Component);

    exports.default = BaseButton;
});
//# sourceMappingURL=Base.js.map
