(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', '../common/util/cx', '../Ripple/index', 'san', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('../common/util/cx'), require('../Ripple/index'), require('san'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.cx, global.index, global.san, global.babelHelpers);
        global.Button = mod.exports;
    }
})(this, function (exports, _cx, _index, _san, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });


    var cx = (0, _cx.create)('button');

    var Button = function (_Component) {
        babelHelpers.inherits(Button, _Component);

        function Button() {
            babelHelpers.classCallCheck(this, Button);
            return babelHelpers.possibleConstructorReturn(this, (Button.__proto__ || Object.getPrototypeOf(Button)).apply(this, arguments));
        }

        babelHelpers.createClass(Button, [{
            key: 'initData',
            value: function initData() {
                return {
                    type: 'button',
                    disabled: false
                };
            }
        }, {
            key: 'attached',
            value: function attached() {
                var _this2 = this;

                if (this.data.get('href')) {
                    this.data.set('originalHref', this.data.get('href'));

                    if (this.data.get('disabled')) {
                        this.setHref('javascript:void(0);');
                    }
                }

                this.watch('disabled', function (val) {
                    if (val) {
                        _this2.setHref('javascript:void(0);');
                        return;
                    }

                    _this2.setHref(_this2.data.get('originalHref'));
                });
            }
        }, {
            key: 'setHref',
            value: function setHref(hrefVal) {
                this.data.set('href', hrefVal);
            }
        }, {
            key: 'click',
            value: function click(e) {
                if (!this.data.get('disabled')) {
                    this.fire('click', e);
                }
            }
        }]);
        return Button;
    }(_san.Component);

    Button.components = {
        'san-touch-ripple': _index.TouchRipple
    };
    Button.template = '\n        <button\n            on-click="click($event)"\n            type="{{type}}"\n            class="{{computedClassName}}"\n            disabled="{{disabled}}">\n            <slot />\n            <san-touch-ripple san-if="!disabled" />\n        </button>\n    ';
    Button.computed = {
        computedClassName: function computedClassName() {
            return cx(this).build();
        }
    };
    Button.dataTypes = {
        type: _san.DataTypes.string,
        disabled: _san.DataTypes.bool
    };
    exports.default = Button;
});
//# sourceMappingURL=Button.js.map
