(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', '../common/util/cx', '../Icon/index', '../Ripple/index', 'san', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('../common/util/cx'), require('../Icon/index'), require('../Ripple/index'), require('san'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.cx, global.index, global.index, global.san, global.babelHelpers);
        global.IconButton = mod.exports;
    }
})(this, function (exports, _cx, _index, _index3, _san, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _index2 = babelHelpers.interopRequireDefault(_index);

    var cx = (0, _cx.create)('button');

    var IconButton = function (_Component) {
        babelHelpers.inherits(IconButton, _Component);

        function IconButton() {
            babelHelpers.classCallCheck(this, IconButton);
            return babelHelpers.possibleConstructorReturn(this, (IconButton.__proto__ || Object.getPrototypeOf(IconButton)).apply(this, arguments));
        }

        babelHelpers.createClass(IconButton, [{
            key: 'initData',
            value: function initData() {
                return {
                    type: 'button',
                    disabled: false
                };
            }
        }, {
            key: 'onClick',
            value: function onClick(e) {
                if (!this.data.get('disabled')) {
                    this.fire('click', e);
                }
            }
        }]);
        return IconButton;
    }(_san.Component);

    IconButton.template = '\n        <button\n            class="{{computedClassName}}"\n            type="{{type}}"\n            disabled="{{disabled}}"\n            on-click="onClick($event)">\n            <san-icon><slot /></san-icon>\n            <san-center-ripple />\n        </button>\n    ';
    IconButton.components = {
        'san-icon': _index2.default,
        'san-center-ripple': _index3.CenterRipple
    };
    IconButton.computed = {
        computedClassName: function computedClassName() {
            return cx(this).addVariants('icon').build();
        }
    };
    IconButton.dataTypes = {
        type: _san.DataTypes.string,
        disabled: _san.DataTypes.bool
    };
    exports.default = IconButton;
});
//# sourceMappingURL=IconButton.js.map
