(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', '../common/util/cx', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('../common/util/cx'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.cx, global.babelHelpers);
        global.CardHeader = mod.exports;
    }
})(this, function (exports, _san, _cx, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _san2 = babelHelpers.interopRequireDefault(_san);

    var cx = (0, _cx.create)('card-header');

    exports.default = _san2.default.defineComponent({
        template: '\n        <div class="{{styleClass}}">\n            <slot name="avatar"></slot>\n            <div class="' + cx.getPartClassName('title-wrap') + '" san-if="title || subTitle">\n                <div class="' + cx.getPartClassName('title') + ' {{titleClass}}">\n                    {{title}}\n                </div>\n                <div class="' + cx.getPartClassName('sub-title') + ' {{subTitleClass}}" san-if="subTitle">\n                    {{subTitle}}\n                </div>\n                <slot name="title-after"></slot>\n            </div>\n            <slot name="after"></slot>\n        </div>\n    ',

        computed: {
            styleClass: function styleClass() {
                return cx(this).build();
            }
        },

        initData: function initData() {
            return {
                title: '',
                subTitle: '',
                titleClass: '',
                subTitleClass: '' };
        },


        dataTypes: {
            title: _san.DataTypes.string,
            subTitle: _san.DataTypes.string,
            titleClass: _san.DataTypes.string,
            subTitleClass: _san.DataTypes.string
        }
    });
});
//# sourceMappingURL=CardHeader.js.map
