(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', '../common/util/cx', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('../common/util/cx'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.cx, global.babelHelpers);
        global.CardText = mod.exports;
    }
})(this, function (exports, _san, _cx, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _san2 = babelHelpers.interopRequireDefault(_san);

    var cx = (0, _cx.create)('card-text');

    exports.default = _san2.default.defineComponent({
        template: '\n        <div class="{{styleClass}}">\n            <slot></slot>\n        </div>\n    ',

        computed: {
            styleClass: function styleClass() {
                return cx(this).build();
            }
        }

    });
});
//# sourceMappingURL=CardText.js.map
