(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', '../common/util/cx', '../Button/index', '../common/util/throttle', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('../common/util/cx'), require('../Button/index'), require('../common/util/throttle'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.cx, global.index, global.throttle, global.babelHelpers);
        global.Carousel = mod.exports;
    }
})(this, function (exports, _san, _cx, _index, _throttle, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _san2 = babelHelpers.interopRequireDefault(_san);

    var cx = (0, _cx.create)('carousel');

    var Carousel = function (_san$Component) {
        babelHelpers.inherits(Carousel, _san$Component);

        function Carousel() {
            var _ref;

            var _temp, _this, _ret;

            babelHelpers.classCallCheck(this, Carousel);

            for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
                args[_key] = arguments[_key];
            }

            return _ret = (_temp = (_this = babelHelpers.possibleConstructorReturn(this, (_ref = Carousel.__proto__ || Object.getPrototypeOf(Carousel)).call.apply(_ref, [this].concat(args))), _this), _this.messages = {
                'UI:carousel-item-attached': function UICarouselItemAttached(arg) {
                    this.items.push(arg.target);
                    this.translateItem(arg.target, this.items.length - 1, this.data.get('activeIndex'));
                },
                'UI:carousel-item-detached': function UICarouselItemDetached(arg) {
                    var len = this.items.length;

                    while (len--) {
                        if (this.items[len] === arg.target) {
                            this.items.splice(len, 1);
                        }
                    }
                }
            }, _temp), babelHelpers.possibleConstructorReturn(_this, _ret);
        }

        babelHelpers.createClass(Carousel, [{
            key: 'initData',
            value: function initData() {

                return {
                    prevIcon: 'keyboard_arrow_left',
                    nextIcon: 'keyboard_arrow_right',
                    activeIndex: 0,
                    items: [],
                    autoplay: true,
                    height: 500,
                    interval: 3000,
                    indicator: false,
                    trigger: 'hover',
                    arrow: 'always',
                    isCycle: true
                };
            }
        }, {
            key: 'inited',
            value: function inited() {
                var _this2 = this;

                this.items = [];
                var setActiveItem = this.setActiveItem.bind(this);
                this.throttledArrowClick = (0, _throttle.throttle)(setActiveItem, 400, {
                    trailing: false
                });
                this.throttledIndicatorHover = (0, _throttle.throttle)(function (index) {
                    _this2.handleIndicatorHover(index);
                }, 400);
            }
        }, {
            key: 'attached',
            value: function attached() {

                this.watch('activeIndex', function (index) {
                    this.resetItemPosition();
                    this.fire('change', index);
                });
                this.startTimer();
            }
        }, {
            key: 'detached',
            value: function detached() {
                this.data.set('activeIndex', 0);
                clearInterval(this.timer);
            }
        }, {
            key: 'setActiveItem',
            value: function setActiveItem(index) {

                index = Number(index);
                var length = this.items.length;
                var isCycle = this.data.get('isCycle');
                if (index < 0) {
                    isCycle ? this.data.set('activeIndex', length - 1) : this.data.set('activeIndex', 0);
                } else if (index >= length) {
                    isCycle ? this.data.set('activeIndex', 0) : this.data.set('activeIndex', length - 1);
                } else {
                    this.data.set('activeIndex', index);
                }
            }
        }, {
            key: 'handleMouseEnter',
            value: function handleMouseEnter() {
                this.data.set('arrow', 'hover');
                this.pauseTimer();
            }
        }, {
            key: 'handleMouseLeave',
            value: function handleMouseLeave() {
                this.data.set('arrow', 'never');
                this.startTimer();
            }
        }, {
            key: 'handleIndicatorClick',
            value: function handleIndicatorClick(index) {
                this.data.set('activeIndex', index);
            }
        }, {
            key: 'handleIndicatorHover',
            value: function handleIndicatorHover(index) {
                if (this.data.get('trigger') === 'hover' && index !== this.data.get('activeIndex')) {
                    this.data.set('activeIndex', index);
                }
            }
        }, {
            key: 'resetItemPosition',
            value: function resetItemPosition() {
                var _this3 = this;

                this.items.forEach(function (item, index) {
                    _this3.translateItem(item, index, _this3.data.get('activeIndex'));
                });
            }
        }, {
            key: 'translateItem',
            value: function translateItem(item, index, activeIndex) {
                var parentWidth = item.el.offsetWidth;
                var length = this.items.length;
                if (index !== activeIndex && length > 2) {
                    index = this.resetIndex(item, index, activeIndex, length);
                }
                item.data.set('active', index === activeIndex);
                item.data.set('translate', parentWidth * (index - activeIndex));
                item.data.set('ready', true);
            }
        }, {
            key: 'resetIndex',
            value: function resetIndex(item, index, activeIndex, length) {
                if (activeIndex === 0 && index === length - 1) {
                    return -1;
                } else if (activeIndex === length - 1 && index === 0) {
                    return length;
                } else if (index < activeIndex - 1 && activeIndex - index >= length / 2) {
                    return length + 1;
                } else if (index > activeIndex + 1 && index - activeIndex >= length / 2) {
                    return -2;
                }
                return index;
            }
        }, {
            key: 'pauseTimer',
            value: function pauseTimer() {
                clearInterval(this.timer);
            }
        }, {
            key: 'startTimer',
            value: function startTimer() {
                var _this4 = this;

                if (this.data.get('interval') <= 0 || !this.data.get('autoplay')) {
                    return;
                }
                this.timer = setInterval(function () {
                    _this4.playSlides();
                }, this.data.get('interval'));
            }
        }, {
            key: 'playSlides',
            value: function playSlides() {
                var activeIndex = this.data.get('activeIndex');
                if (activeIndex < this.items.length - 1) {
                    this.data.set('activeIndex', activeIndex + 1);
                } else {
                    this.data.set('activeIndex', 0);
                }
            }
        }]);
        return Carousel;
    }(_san2.default.Component);

    Carousel.template = '\n        <div\n            class="{{computedClassName}}"\n            on-mouseenter="handleMouseEnter"\n            on-mouseleave="handleMouseLeave">\n            <div\n            class="' + cx.getPartClassName('container') + '"\n            style="height: {{height}}px">\n                <san-icon-button\n                    class="' + cx.getPartClassName('arrow') + ' ' + cx.getPartClassName('arrow-left') + '"\n                    san-if="arrow === \'hover\' || \'always\'"\n                    on-click="throttledArrowClick(activeIndex - 1)">\n                    {{prevIcon}}\n                </san-icon-button>\n\n                <san-icon-button\n                    class="' + cx.getPartClassName('arrow') + ' ' + cx.getPartClassName('arrow-right') + '"\n                    san-if="arrow === \'hover\' || \'always\'"\n                    on-click="throttledArrowClick(activeIndex + 1)">\n                    {{nextIcon}}\n                </san-icon-button>\n\n                <slot></slot>\n\n            </div>\n            <ul\n                class="' + cx.getPartClassName('indicators') + '"\n                san-if="indicator">\n                <li\n                    class="' + cx.getPartClassName('indicator') + '\n                    {{index === activeIndex ? \'is-active\' : \'\' }}"\n                    san-for="item, index in data"\n                    on-mouseenter="throttledIndicatorHover(index)"\n                    on-click="handleIndicatorClick(index)">\n                    <san-button></san-button>\n                </li>\n            </ul>\n        </div>\n    ';
    Carousel.components = {
        'san-button': _index.Button,
        'san-icon-button': _index.IconButton
    };
    Carousel.computed = {
        computedClassName: function computedClassName() {
            return cx(this).build();
        }
    };
    exports.default = Carousel;
});
//# sourceMappingURL=Carousel.js.map
