(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', '../common/util/cx', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('../common/util/cx'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.cx, global.babelHelpers);
        global.CarouselItem = mod.exports;
    }
})(this, function (exports, _san, _cx, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _san2 = babelHelpers.interopRequireDefault(_san);

    var cx = (0, _cx.create)('carousel-item');

    var CarouselItem = function (_san$Component) {
        babelHelpers.inherits(CarouselItem, _san$Component);

        function CarouselItem() {
            babelHelpers.classCallCheck(this, CarouselItem);
            return babelHelpers.possibleConstructorReturn(this, (CarouselItem.__proto__ || Object.getPrototypeOf(CarouselItem)).apply(this, arguments));
        }

        babelHelpers.createClass(CarouselItem, [{
            key: 'initData',
            value: function initData() {
                return {
                    translate: 0,
                    active: false,
                    ready: false
                };
            }
        }, {
            key: 'attached',
            value: function attached() {
                this.dispatch('UI:carousel-item-attached');
            }
        }, {
            key: 'detached',
            value: function detached() {
                this.dispatch('UI:carousel-item-detached');
            }
        }]);
        return CarouselItem;
    }(_san2.default.Component);

    CarouselItem.template = '\n\n        <div\n            class="{{computedClassName}} {{active ? \'is-active\' : \'\' }}"\n            style="transform: translateX({{translate}}px);\n            -webkit-transform: translateX({{translate}}px);"\n            san-if="ready">\n            <slot></slot>\n            <div class="' + cx.getPartClassName('text-mask') + '">\n                <slot name="mask"></slot>\n            </div>\n        </div>\n\n    ';
    CarouselItem.computed = {
        computedClassName: function computedClassName() {
            return cx(this).build();
        }
    };
    exports.default = CarouselItem;
});
//# sourceMappingURL=CarouselItem.js.map
