(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', '../Icon/index', '../Ripple/index', 'classnames', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('../Icon/index'), require('../Ripple/index'), require('classnames'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.index, global.index, global.classnames, global.babelHelpers);
        global.Checkbox = mod.exports;
    }
})(this, function (exports, _san, _index, _index3, _classnames, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _san2 = babelHelpers.interopRequireDefault(_san);

    var _index2 = babelHelpers.interopRequireDefault(_index);

    var _classnames2 = babelHelpers.interopRequireDefault(_classnames);

    var CHECKBOX_DATA_TYPES = {
        number: 'number',
        string: 'string'
    };

    exports.default = _san2.default.defineComponent({
        template: '\n        <label\n            on-click="handleClick"\n            class="{{mainClass}}">\n            <input type="checkbox"\n                disabled="{{disabled}}"\n                name="{{name}}"\n                value="{{value}}"\n                on-change="handleChange($event)"\n                checked="{{realChecked}}">\n            <div class="sm-checkbox-wrapper">\n                <div\n                    class="sm-checkbox-label {{labelClass}}"\n                    san-if="label && labelLeft">\n                    {{label}}\n                </div>\n                <div class="sm-checkbox-icon">\n                    <sm-center-ripple class="sm-checkbox-ripple-wrapper" san-ref="ripple"></sm-center-ripple>\n                    <svg\n                        class="sm-checkbox-icon-uncheck sm-checkbox-svg-icon {{iconClass}}"\n                        san-if="!checkedIcon"\n                        viewBox="0 0 24 24">\n                        <path\n                            d="M19 5v14H5V5h14m0-2H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2z" />\n                    </svg>\n                    <svg\n                        class="sm-checkbox-icon-checked sm-checkbox-svg-icon {{iconClass}}"\n                        san-if="!uncheckIcon"\n                        viewBox="0 0 24 24">\n                        <path d="M19 3H5c-1.11 0-2 .9-2 2v14c0 1.1.89 2 2 2h14c1.11 0 2-.9 2-2V5c0-1.1-.89-2-2-2zm-9 14l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z"/>\n                    </svg>\n                    <svg\n                        class="sm-checkbox-icon-indeterminate sm-checkbox-svg-icon {{iconClass}}"\n                        san-if="!checkedIcon && !uncheckIcon"\n                        viewBox="0 0 24 24">\n                        <path d="M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-2 10H7v-2h10v2z"/>\n                    </svg>\n                    <sm-icon\n                        san-if="uncheckIcon"\n                        class="sm-checkbox-icon-uncheck {{iconClass}}">\n                        {{uncheckIcon}}\n                    </sm-icon>\n                    <sm-icon\n                        san-if="indeterminateIcon"\n                        class="sm-checkbox-icon-indeterminate {{iconClass}}">\n                        {{indeterminateIcon}}\n                    </sm-icon>\n                    <sm-icon\n                        san-if="checkedIcon"\n                        class="sm-checkbox-icon-checked {{iconClass}}">\n                        {{checkedIcon}}\n                    </sm-icon>\n                </div>\n                <div\n                    class="sm-checkbox-label {{labelClass}}"\n                    san-if="label && !labelLeft">{{label}}</div>\n                </div>\n        </label>\n    ',

        components: {
            'sm-icon': _index2.default,
            'sm-center-ripple': _index3.CenterRipple
        },
        initData: function initData() {
            return {
                name: '',
                value: 'ON',
                label: '',
                labelLeft: false,
                labelClass: '',
                uncheckIcon: '',
                checkedIcon: '',
                indeterminateIcon: 'icon',
                iconClass: '',
                checked: [],
                disabled: false
            };
        },

        dataTypes: {
            name: _san.DataTypes.string,
            value: _san.DataTypes.oneOfType([_san.DataTypes.string, _san.DataTypes.number]),
            checked: _san.DataTypes.arrayOf(function (dataValue, key, componentName, dataFullName) {
                if (!/^string|number$/.test(babelHelpers.typeof(dataValue[key]))) {
                    throw new Error('Invalid prop `' + dataFullName + '` supplied to' + ' `' + componentName + '`. Validation failed.');
                }
            }),
            label: _san.DataTypes.string,
            labelLeft: _san.DataTypes.bool,
            labelClass: _san.DataTypes.string,
            uncheckIcon: _san.DataTypes.string,
            checkedIcon: _san.DataTypes.string,
            indeterminateIcon: _san.DataTypes.string,
            iconClass: _san.DataTypes.string,
            disabled: _san.DataTypes.bool
        },
        computed: {
            mainClass: function mainClass() {
                return (0, _classnames2.default)('sm-checkbox', {
                    'label-left': this.data.get('labelLeft'),
                    'disabled': this.data.get('disabled'),
                    'no-label': !this.data.get('label')
                });
            },
            realChecked: function realChecked() {
                return this.data.get('checked').map(function (d) {
                    return d.toString();
                });
            }
        },
        handleClick: function handleClick(e) {
            if (this.data.get('disabled')) {
                return;
            }

            if (e.target.tagName === 'INPUT') {
                return;
            }
            this.ref('ripple').click();
        },
        handleChange: function handleChange(e) {
            var _this = this;

            var _e$target = e.target,
                value = _e$target.value,
                checked = _e$target.checked;

            var inputChecked = this.data.get('checked');

            var inputValue = this.stringToInputValue(value);
            var index = inputChecked.indexOf(inputValue);

            if (checked && index === -1) {
                this.data.push('checked', inputValue);
            }
            if (!checked && index !== -1) {
                this.data.removeAt('checked', index);
            }

            if (this.data.get('canClickToSwitchToIndeterminate')) {
                setTimeout(function () {
                    _this.indeterminateIndex = ++[_this.indeterminateIndex |= 0][0] % 3;
                    _this.data.set('checked', _this.indeterminateIndex !== 0 ? [_this.data.get('value')] : []);
                    _this.data.set('indeterminate', _this.indeterminateIndex === 1);
                    _this.fire('change', _this.indeterminateIndex);
                }, 0);

                return;
            }

            this.fire('change', e);
        },
        checkInputDataType: function checkInputDataType() {
            var _data$get = this.data.get(),
                value = _data$get.value,
                checked = _data$get.checked;

            var valueType = typeof value === 'undefined' ? 'undefined' : babelHelpers.typeof(value);
            this.valueDataType = valueType;

            if (checked) {
                checked.forEach(function (d) {
                    var t = typeof d === 'undefined' ? 'undefined' : babelHelpers.typeof(d);
                    if (CHECKBOX_DATA_TYPES[t] !== valueType) {
                        throw new Error('[SAN-MUI ERROR] the data type of element in Array "checked" and "value"' + ' attribute must be all the same in CHECKBOX component. ' + 'Attribute "value" is ' + valueType + ', but "checked" Array contains ' + t + '}.');
                    }
                });
            }
        },
        stringToInputValue: function stringToInputValue(str) {
            var number = CHECKBOX_DATA_TYPES.number,
                string = CHECKBOX_DATA_TYPES.string;


            var value = void 0;
            switch (this.valueDataType) {
                case number:
                    value = Number(str);
                    break;
                case string:
                    value = String(str);
                    break;
            }
            return value;
        },
        attached: function attached() {
            var _this2 = this;

            this.checkInputDataType();

            this.watch('checked', function (value) {
                _this2.checkInputDataType();

                _this2.data.set('indeterminate', false);
                _this2.fire('input-change', value);
            });

            var input = null;
            this.watch('indeterminate', function (value) {
                input && (input.indeterminate = !!value);
            });

            if (this.el) {
                input = this.el.querySelector('input');
                if (input) {
                    input.indeterminate = !!this.data.get('indeterminate');
                    if (!input.checked && !input.indeterminate) {
                        this.indeterminateIndex = 0;
                    }
                    if (input.checked && input.indeterminate) {
                        this.indeterminateIndex = 1;
                    }
                    if (input.checked && !input.indeterminate) {
                        this.indeterminateIndex = 2;
                    }
                }
            }
        }
    });
});
//# sourceMappingURL=Checkbox.js.map
