(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', '../common/util/cx', '../common/util/css', 'san', '../Icon/index', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('../common/util/cx'), require('../common/util/css'), require('san'), require('../Icon/index'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.cx, global.css, global.san, global.index, global.babelHelpers);
        global.Chip = mod.exports;
    }
})(this, function (exports, _cx, _css, _san, _index, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _css2 = babelHelpers.interopRequireDefault(_css);

    var _san2 = babelHelpers.interopRequireDefault(_san);

    var _index2 = babelHelpers.interopRequireDefault(_index);

    var cx = (0, _cx.create)('chip');

    exports.default = _san2.default.defineComponent({
        components: {
            'san-icon': _index2.default
        },
        template: '\n        <div\n            class="{{computedClassName}}"\n            style="{{wrapperStyle}}"\n            on-click="handleClick($event)">\n\n            <slot></slot>\n            <div\n                class="' + cx.getPartClassName('delete-icon-wrapper') + '"\n                on-click="handleDelete($event)">\n                <san-icon\n\n                    san-if=" showDelete && !disabled"\n                    class="' + cx.getPartClassName('delete-icon') + '"\n                    size="20">\n                    close\n                </san-icon>\n            </div>\n        </div>\n     ',

        initData: function initData() {
            return {
                showDelete: false,
                disabled: false
            };
        },

        dataTypes: {
            showDelete: _san.DataTypes.bool,
            disabled: _san.DataTypes.bool
        },

        handleClick: function handleClick(e) {
            if (!this.data.get('disabled')) {
                this.fire('click', e);
            }
        },
        handleDelete: function handleDelete(e) {
            if (!this.data.get('disabled')) {
                this.fire('delete', e);
            }
        },

        computed: {
            computedClassName: function computedClassName() {
                var disabled = this.data.get('disabled');
                return cx(this).addStates({
                    disabled: disabled,
                    normal: !disabled
                }).build();
            },
            wrapperStyle: function wrapperStyle() {
                var color = this.data.get('color') ? this.data.get('color') : null;
                var backgroundColor = this.data.get('backgroundColor') ? this.data.get('backgroundColor') : null;
                return (0, _css2.default)({
                    color: color,
                    backgroundColor: backgroundColor
                });
            }
        }
    });
});
//# sourceMappingURL=Chip.js.map
