(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', '../common/util/cx', 'san', '../TextField/TextFieldUnderline', '../TextField/index', '../Dialog/index', '../Button/index', 'kolor', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('../common/util/cx'), require('san'), require('../TextField/TextFieldUnderline'), require('../TextField/index'), require('../Dialog/index'), require('../Button/index'), require('kolor'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.cx, global.san, global.TextFieldUnderline, global.index, global.index, global.index, global.kolor, global.babelHelpers);
        global.ColorPicker = mod.exports;
    }
})(this, function (exports, _cx, _san, _TextFieldUnderline, _index, _index3, _index5, _kolor, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _san2 = babelHelpers.interopRequireDefault(_san);

    var _TextFieldUnderline2 = babelHelpers.interopRequireDefault(_TextFieldUnderline);

    var _index2 = babelHelpers.interopRequireDefault(_index);

    var _index4 = babelHelpers.interopRequireDefault(_index3);

    var _index6 = babelHelpers.interopRequireDefault(_index5);

    var _kolor2 = babelHelpers.interopRequireDefault(_kolor);

    var cx = (0, _cx.create)('color-picker');

    exports.default = _san2.default.defineComponent({
        components: {
            'san-underline': _TextFieldUnderline2.default,
            'san-dialog': _index4.default,
            'san-button': _index6.default,
            'san-text-field': _index2.default
        },
        template: '\n        <div class="{{computedClass}}">\n            <span\n                class="' + cx.getPartClassName('indicator-wrapper') + '"\n                on-click="handleClick($event)"\n            >\n                <span\n                >\n                    <i\n                        class="' + cx.getPartClassName('indicator') + '"\n                        style="background-color: {{color}}"\n                    >\n                    </i>\n                </span>\n                {{color}}\n            </span>\n            <san-underline\n                focus="{{focus}}"\n            >\n            </san-underline>\n            <san-dialog\n                open="{{open}}"\n                width="{{alpha ? 307 : 277}}"\n                closeOnClickMask="{{closeOnClickMask}}"\n            >\n                <div class="' + cx.getPartClassName('hsv-wrapper') + '">\n                    <div\n                        class="' + cx.getPartClassName('color-sv') + '"\n                        on-click="handleSvChange($event)"\n                        on-mousedown="handleMouseDown($event, \'sv\')"\n                        on-mouseup="handleMouseUp($event, \'sv\')"\n                        on-mousemove="handleSvMouseMove($event)"\n                        on-mouseleave="handleMouseUp($event, \'sv\')"\n                        style="{{colorComputedStyle}}"\n                    >\n                        <span\n                            class="' + cx.getPartClassName('sv-chooser') + '"\n                            style="left: {{hsv[1] * 200 - 3}}px; top: {{(1 - hsv[2]) * 200 - 3}}px"\n                        >\n                        </span>\n                        <div class="' + cx.getPartClassName('sv-white') + '"></div>\n                        <div class="' + cx.getPartClassName('sv-black') + '"></div>\n                    </div>\n                    <div\n                        class="' + cx.getPartClassName('color-hua') + '"\n                        on-click="handleHuaChange($event)"\n                        on-mousedown="handleMouseDown($event, \'h\')"\n                        on-mouseup="handleMouseUp($event, \'h\')"\n                        on-mousemove="handleHuaMouseMove($event)"\n                        on-mouseleave="handleMouseUp($event, \'h\')"\n                    >\n                        <span\n                            class="' + cx.getPartClassName('hua-chooser') + '"\n                            style="top: {{(hsv[0] / 360) * 200 - 3}}px"\n                        >\n                        </span>\n                    </div>\n                    <div\n                        class="' + cx.getPartClassName('color-alpha') + '"\n                        on-click="handleAlphaChange($event)"\n                        on-mousedown="handleMouseDown($event, \'a\')"\n                        on-mouseup="handleMouseUp($event, \'a\')"\n                        on-mousemove="handleAlphaMouseMove($event)" \n                        on-mouseleave="handleMouseUp($event, \'a\')"\n                        san-if="alpha"\n                    >\n                        <div\n                            class="' + cx.getPartClassName('alpha-basic') + '"\n                            style="{{alphaComputedStyle}}"\n                        >\n                        </div>\n                        <span\n                            class="' + cx.getPartClassName('alpha-chooser') + '"\n                            style="top: {{rgba[3] * 200 - 3}}px"\n                        >\n                        </span>\n                    </div>\n                </div>\n                <div class="' + cx.getPartClassName('rgb-whole-wrapper') + '" san-if="alpha">\n                    <div class="' + cx.getPartClassName('rgb-wrapper') + '">\n                        <san-text-field\n                            label="R"\n                            inputClass="' + cx.getPartClassName('rgb-input-width') + '"\n                            underlineClass="' + cx.getPartClassName('rgb-input-width') + '"\n                            inputValue="{{rgba[0]}}"\n                            on-input-change="handleRgbInput($event, 0)"\n                        />\n                    </div>\n                    <div class="' + cx.getPartClassName('rgb-wrapper') + '">\n                        <san-text-field\n                            label="G"\n                            inputClass="' + cx.getPartClassName('rgb-input-width') + '"\n                            underlineClass="' + cx.getPartClassName('rgb-input-width') + '"\n                            inputValue="{{rgba[1]}}"\n                            on-input-change="handleRgbInput($event, 1)"\n                        />\n                    </div>\n                    <div class="' + cx.getPartClassName('rgb-wrapper') + '">\n                        <san-text-field\n                            label="B"\n                            inputClass="' + cx.getPartClassName('rgb-input-width') + '"\n                            underlineClass="' + cx.getPartClassName('rgb-input-width') + '"\n                            inputValue="{{rgba[2]}}"\n                            on-input-change="handleRgbInput($event, 2)"\n                        />\n                    </div>\n                    <div class="' + cx.getPartClassName('rgb-wrapper') + '">\n                        <san-text-field\n                            label="A"\n                            inputClass="' + cx.getPartClassName('rgb-input-width') + '"\n                            underlineClass="' + cx.getPartClassName('rgb-input-width') + '"\n                            inputValue="{{rgba[3]}}"\n                            on-input-change="handleAlphaInput($event)"\n                        />\n                    </div>\n                </div>\n                <div class="' + cx.getPartClassName('hex-wrapper') + '" san-if="!alpha">\n                    <san-text-field\n                        inputClass="' + cx.getPartClassName('hex-input-width') + '"\n                        underlineClass="' + cx.getPartClassName('hex-input-width') + '"\n                        label="hex"\n                        inputValue="{{hex}}"\n                        on-input-change="handleHexInput($event)"\n                    />\n                </div>\n                <div slot="actions">\n                    <san-button on-click="handleCancel" variants="danger">\u53D6\u6D88</san-button>\n                    <san-button on-click="handleConfirm" variants="info">\u786E\u5B9A</san-button>\n                </div>\n            </san-dialog>\n        </div>\n    ',

        initData: function initData() {
            return {
                color: '#ffffff',
                alpha: false,
                hsv: [0, 0, 0],
                rgba: [0, 0, 0, 0],
                hex: '',
                svDraggable: false,
                hDraggable: false,
                aDraggable: false
            };
        },
        attached: function attached() {
            var color = this.data.get('color') || '#ffffff';
            this.initColorParam(color);
        },


        computed: {
            computedClass: function computedClass() {
                return cx(this).build();
            },
            colorComputedStyle: function colorComputedStyle() {
                var h = this.data.get('hsv[0]');
                var color = _kolor2.default.hsva(h, 1, 1, 1).hex();
                return {
                    'background-color': color
                };
            },
            alphaComputedStyle: function alphaComputedStyle() {
                var _data$get = this.data.get('hsv'),
                    _data$get2 = babelHelpers.slicedToArray(_data$get, 3),
                    h = _data$get2[0],
                    s = _data$get2[1],
                    v = _data$get2[2];

                var colorBegin = _kolor2.default.hsva(h, s, v, 1).rgba().css();
                var colorEnd = _kolor2.default.hsva(h, s, v, 0).rgba().css();
                var color = 'linear-gradient(0deg, ' + colorBegin + ', ' + colorEnd + ')';
                return {
                    background: color
                };
            }
        },

        initColorParam: function initColorParam(color) {
            var k = (0, _kolor2.default)(color);
            var hsv = k.hsv().toArray();
            var rgba = k.rgba().toArray();
            var hex = k.hex();

            this.data.set('hsv', hsv);
            this.data.set('rgba', rgba);
            this.data.set('hex', hex);
            this.data.get('alpha') ? this.data.set('color', k.rgba().css()) : this.data.set('color', hex);
        },
        rgbTohsv: function rgbTohsv() {
            var _data$get3 = this.data.get('rgba'),
                _data$get4 = babelHelpers.slicedToArray(_data$get3, 3),
                r = _data$get4[0],
                g = _data$get4[1],
                b = _data$get4[2];

            var k = _kolor2.default.rgb(r, g, b).hsv();

            var hsv = k.toArray();
            hsv[1] = hsv[1].toFixed(3);
            hsv[2] = hsv[2].toFixed(3);
            this.data.set('hsv', hsv);
        },
        hsvTorgb: function hsvTorgb() {
            var _data$get5 = this.data.get('hsv'),
                _data$get6 = babelHelpers.slicedToArray(_data$get5, 3),
                h = _data$get6[0],
                s = _data$get6[1],
                v = _data$get6[2];

            var k = _kolor2.default.hsv(h, s, v).rgb();

            var _k$toArray = k.toArray(),
                _k$toArray2 = babelHelpers.slicedToArray(_k$toArray, 3),
                r = _k$toArray2[0],
                g = _k$toArray2[1],
                b = _k$toArray2[2];

            var hex = k.hex();
            this.data.set('rgba[0]', r);
            this.data.set('rgba[1]', g);
            this.data.set('rgba[2]', b);
            this.data.set('hex', hex);
        },
        hexTohsv: function hexTohsv() {
            var hex = this.data.get('hex');
            var hsv = (0, _kolor2.default)(hex).hsv().toArray();
            hsv[1] = hsv[1].toFixed(3);
            hsv[2] = hsv[2].toFixed(3);
            this.data.set('hsv', hsv);
        },
        openPanel: function openPanel() {
            this.data.set('focus', true);
            this.data.set('open', true);
        },
        closePanel: function closePanel() {
            this.data.set('focus', false);
            this.data.set('open', false);
        },
        handleClick: function handleClick(e) {
            this.openPanel();
            this.initColorParam(this.data.get('color'));
        },
        handleConfirm: function handleConfirm(e) {
            this.closePanel();

            var _data$get7 = this.data.get('hsv'),
                _data$get8 = babelHelpers.slicedToArray(_data$get7, 3),
                h = _data$get8[0],
                s = _data$get8[1],
                v = _data$get8[2];

            var color = void 0;
            if (this.data.get('alpha')) {
                var a = parseFloat(this.data.get('rgba[3]')).toFixed(2);
                color = _kolor2.default.hsva(h, s, v, a).rgba().css();
            } else {
                color = _kolor2.default.hsv(h, s, v).hex();
            }
            this.data.set('color', color);
            this.fire('color-change');
        },
        handleCancel: function handleCancel(e) {
            this.closePanel();
        },
        handleMouseDown: function handleMouseDown(e, prefix) {
            e.preventDefault();
            var key = prefix + 'Draggable';
            this.data.set(key, true);
        },
        handleMouseUp: function handleMouseUp(e, prefix) {
            e.preventDefault();
            var key = prefix + 'Draggable';
            this.data.set(key, false);
        },
        handleSvMouseMove: function handleSvMouseMove(e) {
            e.preventDefault();
            if (this.data.get('svDraggable')) {
                this.handleSvChange(e);
            }
        },
        handleHuaMouseMove: function handleHuaMouseMove(e) {
            e.preventDefault();
            if (this.data.get('hDraggable')) {
                this.handleHuaChange(e);
            }
        },
        handleAlphaMouseMove: function handleAlphaMouseMove(e) {
            e.preventDefault();
            if (this.data.get('aDraggable')) {
                this.handleAlphaChange(e);
            }
        },
        handleSvChange: function handleSvChange(e) {
            var target = e.currentTarget;
            var outX = target.offsetLeft;
            var outY = target.offsetTop;
            var clientX = e.clientX;
            var clientY = e.clientY;
            var s = ((clientX - outX) / 200).toFixed(3);
            var v = (1 - (clientY - outY) / 200).toFixed(3);

            s = s > 1 ? 1 : s < 0 ? 0 : s;
            v = v > 1 ? 1 : v < 0 ? 0 : v;
            this.data.set('hsv[1]', s);
            this.data.set('hsv[2]', v);
            this.hsvTorgb();
        },
        handleHuaChange: function handleHuaChange(e) {
            var target = e.currentTarget;
            var outY = target.offsetTop;
            var clientY = e.clientY;
            var h = (clientY - outY) / 200 * 360;

            h = h > 360 ? 360 : h < 0 ? 0 : h;
            this.data.set('hsv[0]', h);
            this.hsvTorgb();
        },
        handleAlphaChange: function handleAlphaChange(e) {
            var target = e.currentTarget;
            var outY = target.offsetTop;
            var clientY = e.clientY;
            var a = ((clientY - outY) / 200).toFixed(2);

            a = a > 1 ? 1 : a < 0 ? 0 : a;
            this.data.set('rgba[3]', a);
        },
        handleRgbInput: function handleRgbInput(e, index) {
            var val = e.target.value;

            var formatVal = parseInt(val, 10);
            var value = isNaN(formatVal) ? '' : Math.min(255, formatVal);
            this.data.set('rgba[' + index + ']', value);
            e.target.value = value;
            this.rgbTohsv();
        },
        handleAlphaInput: function handleAlphaInput(e) {
            var val = e.target.value;
            if (val.indexOf('.') === val.length - 1) {
                return;
            }

            var formatVal = parseFloat(val.substring(0, 4));
            if (isNaN(formatVal)) {
                this.data.set('rgba[3]', '');
                e.target.value = '';
            } else {
                formatVal = formatVal >= 1 ? 1 : formatVal;
                this.data.set('rgba[3]', formatVal);
                e.target.value = formatVal;
            }
        },
        handleHexInput: function handleHexInput(e) {
            var val = e.target.value;
            this.data.set('hex', val);

            var reg = /^\#[0-9a-fA-F]{6}$/;
            if (reg.test(val)) {
                this.hexTohsv();
            }
        }
    });
});
//# sourceMappingURL=ColorPicker.js.map
