(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', '../common/util/cx', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('../common/util/cx'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.cx, global.babelHelpers);
        global.Date = mod.exports;
    }
})(this, function (exports, _san, _cx, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _san2 = babelHelpers.interopRequireDefault(_san);

    var cx = (0, _cx.create)('date-picker-date');

    exports.default = _san2.default.defineComponent({

        template: '\n        <div class="{{computedClassName}}" on-click="click">\n            <div class="' + cx.getPartClassName('cell') + '">\n                {{part ? \'\' : date }}\n            </div>\n        </div>\n    ',

        computed: {
            computedClassName: function computedClassName() {
                var weekend = this.data.get('weekend');
                var active = this.data.get('active');
                var today = this.data.get('today');
                var part = this.data.get('part');
                var disabled = this.data.get('disabled');
                return cx(this).addVariants(part).addStates({
                    weekend: weekend,
                    active: active,
                    today: today,
                    disabled: disabled
                }).build();
            }
        },

        click: function click() {
            if (!this.data.get('disabled')) {
                this.fire('pick');
            }
        }
    });
});
//# sourceMappingURL=Date.js.map
