(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', '../Dialog/index', 'san', 'moment', './constant', './Month', '../Button/index', './Header', './MonthCarousel', './Year', './Week', '../TextField/index', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('../Dialog/index'), require('san'), require('moment'), require('./constant'), require('./Month'), require('../Button/index'), require('./Header'), require('./MonthCarousel'), require('./Year'), require('./Week'), require('../TextField/index'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.index, global.san, global.moment, global.constant, global.Month, global.index, global.Header, global.MonthCarousel, global.Year, global.Week, global.index, global.babelHelpers);
        global.DatePicker = mod.exports;
    }
})(this, function (exports, _index, _san, _moment, _constant, _Month, _index3, _Header, _MonthCarousel, _Year, _Week, _index5, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _index2 = babelHelpers.interopRequireDefault(_index);

    var _moment2 = babelHelpers.interopRequireDefault(_moment);

    var _Month2 = babelHelpers.interopRequireDefault(_Month);

    var _index4 = babelHelpers.interopRequireDefault(_index3);

    var _Header2 = babelHelpers.interopRequireDefault(_Header);

    var _MonthCarousel2 = babelHelpers.interopRequireDefault(_MonthCarousel);

    var _Year2 = babelHelpers.interopRequireDefault(_Year);

    var _Week2 = babelHelpers.interopRequireDefault(_Week);

    var _index6 = babelHelpers.interopRequireDefault(_index5);

    var DatePicker = function (_Component) {
        babelHelpers.inherits(DatePicker, _Component);

        function DatePicker() {
            babelHelpers.classCallCheck(this, DatePicker);
            return babelHelpers.possibleConstructorReturn(this, (DatePicker.__proto__ || Object.getPrototypeOf(DatePicker)).apply(this, arguments));
        }

        babelHelpers.createClass(DatePicker, [{
            key: 'initData',
            value: function initData() {
                return {
                    value: '',
                    open: false,
                    yearPanelOpen: false,
                    format: _constant.FORMAT,

                    label: '',
                    labelFloat: false,
                    labelClass: '',
                    labelFocusClass: '',
                    hintText: '选择日期',
                    hintTextClass: '',
                    inputClass: '',
                    errorText: '',
                    errorColor: '',
                    helpText: '',
                    helpTextClass: '',
                    maxLength: 0,
                    disabled: false,
                    fullWidth: true,
                    underlineShow: true,
                    underlineClass: '',
                    underlineFocusClass: '',
                    focus: false,
                    inputValue: '',
                    charLength: 0,
                    float: true,
                    multiLine: false,
                    icon: ''
                };
            }
        }, {
            key: 'inited',
            value: function inited() {
                var _this2 = this;

                var _data$get = this.data.get(),
                    value = _data$get.value,
                    format = _data$get.format;

                var date = (0, _moment2.default)(value, format);

                if (!date.isValid()) {
                    date = (0, _moment2.default)();
                }

                this.data.set('visualDate', date.format(_constant.FORMAT));

                this.data.set('pickedDate', date.format(_constant.FORMAT));

                this.watch('pickedDate', function (date) {
                    return _this2.data.set('visualDate', date);
                });

                this.watch('value', function (newValue) {
                    var _data$get2 = _this2.data.get(),
                        format = _data$get2.format,
                        visualDate = _data$get2.visualDate,
                        pickedDate = _data$get2.pickedDate;

                    var value = (0, _moment2.default)(newValue, format);

                    if (!value.isValid()) {
                        _this2.fire('invalid', newValue);
                        return;
                    }

                    if (!value.isSame(visualDate)) {
                        _this2.data.set('visualDate', value.format(_constant.FORMAT));
                    }

                    if (!value.isSame(pickedDate)) {
                        _this2.data.set('pickedDate', value.format(_constant.FORMAT));
                    }
                });
            }
        }, {
            key: 'attached',
            value: function attached() {}
        }, {
            key: 'openDialog',
            value: function openDialog() {
                this.data.set('open', true);
            }
        }, {
            key: 'cancel',
            value: function cancel() {
                this.data.set('open', false);
            }
        }, {
            key: 'confirm',
            value: function confirm() {

                var format = this.data.get('format');
                var value = (0, _moment2.default)(this.data.get('pickedDate'), _constant.FORMAT).format(format);

                this.data.set('open', false);
                this.data.set('value', value);
            }
        }, {
            key: 'toggleYearPanel',
            value: function toggleYearPanel() {
                this.data.set('yearPanelOpen', !this.data.get('yearPanelOpen'));
            }
        }, {
            key: 'selectYear',
            value: function selectYear() {
                this.data.set('yearPanelOpen', false);
            }
        }]);
        return DatePicker;
    }(_san.Component);

    DatePicker.template = '\n        <div class="sm-date-picker" ref="anchor">\n            <san-text-field\n                label="{{label}}"\n                labelFloat="{{labelFloat}}"\n                labelClass="{{labelClass}}"\n                labelFocusClass="{{labelFocusClass}}"\n                hintText="{{hintText}}"\n                hintTextClass="{{hintTextClass}}"\n                inputClass="{{inputClass}}"\n                errorText="{{errorText}}"\n                errorColor="{{errorColor}}"\n                helpText="{{helpText}}"\n                helpTextClass="{{helpTextClass}}"\n                maxLength="{{maxLength}}"\n                disabled="{{disabled}}"\n                readOnly="{{!0}}"\n                fullWidth="{{fullWidth}}"\n                underlineShow="{{!0}}"\n                focus="{{!1}}"\n                inputValue="{=value=}"\n                charLength="{{charLength}}"\n                float="{{float}}"\n                multiLine="{{multiLine}}"\n                icon="{{icon}}"\n                on-input-focus="openDialog" />\n            <san-dialog\n                variants="date-picker"\n                useMask="{{!0}}"\n                closeOnClickMask="{{false}}"\n                open="{=open=}"\n                width="{{310}}">\n                <san-header\n                    slot="title"\n                    date="{{pickedDate}}"\n                    on-open="toggleYearPanel" />\n                <san-month-carousel date="{=visualDate=}"/>\n                <san-week />\n                <san-month date="{=visualDate=}" value="{=pickedDate=}" isDisabled="{{isDisabled}}"/>\n                <san-year\n                    san-if="{{yearPanelOpen}}"\n                    date="{=pickedDate=}"\n                    on-select="selectYear" />\n                <footer slot="actions">\n                    <san-button on-click="cancel" variants="info">\u53D6\u6D88</san-button>\n                    <san-button on-click="confirm" variants="info">\u786E\u8BA4</san-button>\n                </footer>\n            </san-dialog>\n        </div>\n    ';
    DatePicker.components = {
        'san-dialog': _index2.default,
        'san-month': _Month2.default,
        'san-button': _index4.default,
        'san-header': _Header2.default,
        'san-month-carousel': _MonthCarousel2.default,
        'san-year': _Year2.default,
        'san-week': _Week2.default,
        'san-text-field': _index6.default
    };
    DatePicker.dataTypes = {
        value: _san.DataTypes.string,
        open: _san.DataTypes.bool,
        format: _san.DataTypes.string,
        disabled: _san.DataTypes.bool
    };
    exports.default = DatePicker;
});
//# sourceMappingURL=DatePicker.js.map
