(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', '../common/util/cx', 'moment', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('../common/util/cx'), require('moment'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.cx, global.moment, global.babelHelpers);
        global.Header = mod.exports;
    }
})(this, function (exports, _san, _cx, _moment, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _moment2 = babelHelpers.interopRequireDefault(_moment);

    var cx = (0, _cx.create)('date-picker-header');

    var DatePickerHeader = function (_Component) {
        babelHelpers.inherits(DatePickerHeader, _Component);

        function DatePickerHeader() {
            babelHelpers.classCallCheck(this, DatePickerHeader);
            return babelHelpers.possibleConstructorReturn(this, (DatePickerHeader.__proto__ || Object.getPrototypeOf(DatePickerHeader)).apply(this, arguments));
        }

        babelHelpers.createClass(DatePickerHeader, [{
            key: 'onYearClick',
            value: function onYearClick() {
                this.fire('open');
            }
        }]);
        return DatePickerHeader;
    }(_san.Component);

    DatePickerHeader.template = '\n        <header class="{{computedClassName}}">\n            <div\n                class="' + cx.getPartClassName('year') + '"\n                on-click="onYearClick">\n                {{year}}\n            </div>\n            <p class="' + cx.getPartClassName('label') + '">{{label}}</p>\n        </header>\n    ';
    DatePickerHeader.computed = {
        computedClassName: function computedClassName() {
            return cx(this).build();
        },
        year: function year() {
            return (0, _moment2.default)(this.data.get('date')).format('YYYY年');
        },
        label: function label() {
            return (0, _moment2.default)(this.data.get('date')).locale('zh-cn').format('MM月DD日 dddd');
        }
    };
    exports.default = DatePickerHeader;
});
//# sourceMappingURL=Header.js.map
