(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', 'moment', './Date', '../Icon/index', '../Ripple/index', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('moment'), require('./Date'), require('../Icon/index'), require('../Ripple/index'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.moment, global.Date, global.index, global.index, global.babelHelpers);
        global.Month = mod.exports;
    }
})(this, function (exports, _san, _moment, _Date, _index, _index3, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _moment2 = babelHelpers.interopRequireDefault(_moment);

    var _Date2 = babelHelpers.interopRequireDefault(_Date);

    var _index2 = babelHelpers.interopRequireDefault(_index);

    var FORMAT = 'YYYY-MM-DD';

    var empty = function empty() {
        return false;
    };

    var Month = function (_Component) {
        babelHelpers.inherits(Month, _Component);

        function Month() {
            babelHelpers.classCallCheck(this, Month);
            return babelHelpers.possibleConstructorReturn(this, (Month.__proto__ || Object.getPrototypeOf(Month)).apply(this, arguments));
        }

        babelHelpers.createClass(Month, [{
            key: 'initData',
            value: function initData() {
                return {
                    month: (0, _moment2.default)().format(FORMAT),
                    format: FORMAT
                };
            }
        }, {
            key: 'attached',
            value: function attached() {}
        }, {
            key: 'setDate',
            value: function setDate(date) {
                this.data.set('value', (0, _moment2.default)(this.data.get('date')).date(date).format(FORMAT));
            }
        }]);
        return Month;
    }(_san.Component);

    Month.template = '\n        <div class="sm-date-picker-month">\n            <san-date-picker-date\n                san-for="date in dates"\n                date="{{date.value}}"\n                weekend="{{date.weekend}}"\n                active="{{date.active}}"\n                today="{{date.today}}"\n                part="{{date.part}}"\n                disabled="{{date.disabled}}"\n                on-pick="setDate(date.value)"/>\n        </div>\n    ';
    Month.components = {
        'san-date-picker-date': _Date2.default,
        'san-icon': _index2.default,
        'san-center-ripple': _index3.CenterRipple
    };
    Month.computed = {
        dates: function dates() {
            var today = (0, _moment2.default)();
            var value = (0, _moment2.default)(this.data.get('value'));
            var date = (0, _moment2.default)(this.data.get('date'));
            var monthBegin = (0, _moment2.default)(date).startOf('month');
            var monthEnd = (0, _moment2.default)(date).endOf('month');
            var begin = (0, _moment2.default)(monthBegin).startOf('week');
            var end = (0, _moment2.default)(monthEnd).endOf('week');
            var isDisabled = this.data.get('isDisabled') || empty;
            var dates = [];

            while (begin.isBefore(end)) {

                dates.push({
                    disabled: isDisabled(begin.unix()),
                    value: begin.date(),
                    weekend: begin.weekday() > 4,
                    active: begin.isSame(value, 'd'),
                    today: begin.isSame(today, 'd'),
                    part: begin.isBefore(monthBegin) ? 'before' : begin.isAfter(monthEnd) ? 'after' : ''
                });

                begin.add(1, 'd');
            }

            return dates;
        }
    };
    exports.default = Month;
});
//# sourceMappingURL=Month.js.map
