(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', '../common/util/cx', '../Icon/index', '../Ripple/index', 'moment', './constant', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('../common/util/cx'), require('../Icon/index'), require('../Ripple/index'), require('moment'), require('./constant'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.cx, global.index, global.index, global.moment, global.constant, global.babelHelpers);
        global.MonthCarousel = mod.exports;
    }
})(this, function (exports, _san, _cx, _index, _index3, _moment, _constant, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _san2 = babelHelpers.interopRequireDefault(_san);

    var _index2 = babelHelpers.interopRequireDefault(_index);

    var _moment2 = babelHelpers.interopRequireDefault(_moment);

    var cx = (0, _cx.create)('date-picker-month-carousel');

    exports.default = _san2.default.defineComponent({

        components: {
            'san-icon': _index2.default,
            'san-center-ripple': _index3.CenterRipple
        },

        template: '\n        <div class="' + cx.getPartClassName() + '">\n            <div class="' + cx.getPartClassName('prev') + '" on-click="prev">\n                <san-icon>keyboard_arrow_left</san-icon>\n                <san-center-ripple />\n            </div>\n            <label>{{text}}</label>\n            <div class="' + cx.getPartClassName('next') + '" on-click="next">\n                <san-icon>keyboard_arrow_right</san-icon>\n                <san-center-ripple />\n            </div>\n        </div>\n    ',

        computed: {
            text: function text() {
                var date = this.data.get('date');
                return (0, _moment2.default)(date).format('YYYY 年 MM 月');
            }
        },

        prev: function prev() {
            var date = (0, _moment2.default)(this.data.get('date')).subtract(1, 'month').format(_constant.FORMAT);
            this.data.set('date', date);
        },
        next: function next() {
            var date = (0, _moment2.default)(this.data.get('date')).add(1, 'month').format(_constant.FORMAT);
            this.data.set('date', date);
        }
    });
});
//# sourceMappingURL=MonthCarousel.js.map
