(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.babelHelpers);
        global.Week = mod.exports;
    }
})(this, function (exports, _san, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _san2 = babelHelpers.interopRequireDefault(_san);

    var WEEKS = ['日', '一', '二', '三', '四', '五', '六'];

    exports.default = _san2.default.defineComponent({

        template: '\n        <div class="sm-date-picker-week">\n            <i san-for="week in weeks">{{week}}</i>\n        </div>\n    ',

        initData: function initData() {
            return {
                weeks: WEEKS
            };
        }
    });
});
//# sourceMappingURL=Week.js.map
