(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', '../common/util/cx', 'moment', './constant', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('../common/util/cx'), require('moment'), require('./constant'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.cx, global.moment, global.constant, global.babelHelpers);
        global.Year = mod.exports;
    }
})(this, function (exports, _san, _cx, _moment, _constant, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _moment2 = babelHelpers.interopRequireDefault(_moment);

    var cx = (0, _cx.create)('date-picker-year');
    var years = Array.apply(null, new Array(200)).map(function (_, i) {
        return i + 1900;
    });

    var DatePickerYear = function (_Component) {
        babelHelpers.inherits(DatePickerYear, _Component);

        function DatePickerYear() {
            babelHelpers.classCallCheck(this, DatePickerYear);
            return babelHelpers.possibleConstructorReturn(this, (DatePickerYear.__proto__ || Object.getPrototypeOf(DatePickerYear)).apply(this, arguments));
        }

        babelHelpers.createClass(DatePickerYear, [{
            key: 'initData',
            value: function initData() {
                return {
                    years: years
                };
            }
        }, {
            key: 'attached',
            value: function attached() {
                var year = this.data.get('year');
                var main = this.el;
                var target = main.querySelector('[data-year=\'' + year + '\']');
                if (target) {
                    main.scrollTop = target.offsetTop - main.offsetHeight / 2;
                }
            }
        }, {
            key: 'click',
            value: function click(year) {
                var date = (0, _moment2.default)(this.data.get('date')).year(year);
                this.data.set('date', date.format(_constant.FORMAT));
                this.fire('select');
            }
        }]);
        return DatePickerYear;
    }(_san.Component);

    DatePickerYear.template = '\n        <div class="' + cx.getPartClassName() + '">\n            <div\n                san-for="y in years"\n                data-year="{{y}}"\n                on-click="click(y)"\n                class="' + cx.getPartClassName('item') + ' {{year === y ? \'state-active\' : \'\'}}">\n                {{y}}\n            </div>\n        </div>\n    ';
    DatePickerYear.computed = {
        year: function year() {
            return (0, _moment2.default)(this.data.get('date')).year();
        }
    };
    exports.default = DatePickerYear;
});
//# sourceMappingURL=Year.js.map
