(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', '../common/util/cx', '../Layer/Layer', '../Mask/index', 'san', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('../common/util/cx'), require('../Layer/Layer'), require('../Mask/index'), require('san'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.cx, global.Layer, global.index, global.san, global.babelHelpers);
        global.Dialog = mod.exports;
    }
})(this, function (exports, _cx, _Layer2, _index, _san, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _Layer3 = babelHelpers.interopRequireDefault(_Layer2);

    var _index2 = babelHelpers.interopRequireDefault(_index);

    var cx = (0, _cx.create)('dialog');

    var Dialog = function (_Layer) {
        babelHelpers.inherits(Dialog, _Layer);

        function Dialog() {
            babelHelpers.classCallCheck(this, Dialog);
            return babelHelpers.possibleConstructorReturn(this, (Dialog.__proto__ || Object.getPrototypeOf(Dialog)).apply(this, arguments));
        }

        babelHelpers.createClass(Dialog, [{
            key: 'initData',
            value: function initData() {
                return {
                    open: false,
                    useMask: true,
                    closeOnClickMask: true,
                    width: 760
                };
            }
        }, {
            key: 'lockBodyScroll',
            value: function lockBodyScroll(locked) {
                var bodyClass = document.body.className;
                if (locked) {
                    if (!bodyClass.match(/\bsm-lockoverflow\b/)) {
                        document.body.className = bodyClass + ' sm-lockoverflow';
                    }
                } else {
                    document.body.className = bodyClass.replace(/(?:\s|\b)sm-lockoverflow\b/, '');
                }
            }
        }, {
            key: 'attached',
            value: function attached() {
                var _this2 = this;

                babelHelpers.get(Dialog.prototype.__proto__ || Object.getPrototypeOf(Dialog.prototype), 'attached', this).call(this);
                this.watch('open', function (open) {
                    _this2.lockBodyScroll(open);
                });
                this.lockBodyScroll(this.data.get('open'));
            }
        }, {
            key: 'detached',
            value: function detached() {
                babelHelpers.get(Dialog.prototype.__proto__ || Object.getPrototypeOf(Dialog.prototype), 'detached', this).call(this);
                this.lockBodyScroll(false);
            }
        }, {
            key: 'onMaskClick',
            value: function onMaskClick() {
                if (this.data.get('closeOnClickMask')) {
                    this.data.set('open', false);
                }
                this.fire('clickMask');
            }
        }]);
        return Dialog;
    }(_Layer3.default);

    Dialog.template = '\n        <div class="{{computedClassName}}" style="{{mainStyle}}">\n            <div class="' + cx.getPartClassName('content') + '" style="{{contentStyle}}">\n                <div class="' + cx.getPartClassName('scroller') + '" style="{{scrollerStyle}}">\n                    <h3 class="' + cx.getPartClassName('title') + '">\n                        <slot name="title">{{title}}</slot>\n                    </h3>\n                    <div class="' + cx.getPartClassName('body') + '">\n                        <slot></slot>\n                    </div>\n                </div>\n                <div class="' + cx.getPartClassName('actions') + '">\n                    <slot name="actions"></slot>\n                </div>\n            </div>\n            <sm-mask\n                s-if="useMask"\n                on-close="onMaskClick"\n                open="{{open}}"\n                z-index="{{-1}}" />\n        </div>\n    ';
    Dialog.components = {
        'sm-mask': _index2.default
    };
    Dialog.computed = {
        mainStyle: function mainStyle() {
            return this.data.get('open') ? null : { display: 'none' };
        },
        contentStyle: function contentStyle() {
            return {
                width: this.data.get('width') + 'px'
            };
        },
        computedClassName: function computedClassName() {
            return cx(this).build();
        },
        scrollerStyle: function scrollerStyle() {
            var maxHeight = this.data.get('maxHeight');
            return maxHeight == null ? null : {
                'max-height': maxHeight,
                'overflow': 'auto'
            };
        }
    };
    Dialog.dataTypes = {
        open: _san.DataTypes.bool,
        useMask: _san.DataTypes.bool,
        closeOnClickMask: _san.DataTypes.bool,
        width: _san.DataTypes.number
    };
    exports.default = Dialog;
});
//# sourceMappingURL=Dialog.js.map
