(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', '../common/util/cx', '../common/util/css', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('../common/util/cx'), require('../common/util/css'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.cx, global.css, global.babelHelpers);
        global.Drawer = mod.exports;
    }
})(this, function (exports, _san, _cx, _css, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _san2 = babelHelpers.interopRequireDefault(_san);

    var _css2 = babelHelpers.interopRequireDefault(_css);

    var cx = (0, _cx.create)('drawer');

    var POSITION_SIZE_MAP = {
        top: 'height',
        bottom: 'height',
        left: 'width',
        right: 'width'
    };

    var POSITION_TRANSLATE_MAP = {
        top: [0, 1],
        bottom: [0, -1],
        left: [1, 0],
        right: [-1, 0]
    };

    var POSITION_BASE_MAP = {
        top: {
            left: 0,
            right: 0
        },
        bottom: {
            left: 0,
            right: 0
        },
        left: {
            top: 0,
            bottom: 0
        },
        right: {
            top: 0,
            bottom: 0
        }
    };

    exports.default = _san2.default.defineComponent({

        template: '\n        <div class="{{computedClassName}}" >\n            <div\n                class="' + cx.getPartClassName('content') + '"\n                style="{{contentStyle}}">\n                <slot />\n            </div>\n            <div\n                class="' + cx.getPartClassName('mask') + '"\n                style="{{maskStyle}}"\n                san-if="{{useMask}}"\n                on-click="close"/>\n        </div>\n    ',

        initData: function initData() {
            return {
                open: false,
                size: 300,
                useMask: true,
                position: 'left'
            };
        },


        dataTypes: {
            open: _san.DataTypes.bool,
            size: _san.DataTypes.number,
            useMask: _san.DataTypes.bool,
            position: _san.DataTypes.oneOf(['left', 'right', 'top', 'bottom'])
        },

        computed: {
            computedClassName: function computedClassName() {
                var open = this.data.get('open');
                var position = this.data.get('position');
                return cx(this).addStates({
                    open: open,
                    hidden: !open
                }).addVariants(position).build();
            },
            contentStyle: function contentStyle() {
                var _babelHelpers$extends;

                var open = this.data.get('open');
                var size = this.data.get('size');
                var position = this.data.get('position');

                var transform = open ? 'translate(' + POSITION_TRANSLATE_MAP[position].map(function (i) {
                    return i * size + 'px';
                }).join(',') + ')' : '';

                var style = (0, _css2.default)(babelHelpers.extends({}, POSITION_BASE_MAP[position], (_babelHelpers$extends = {}, babelHelpers.defineProperty(_babelHelpers$extends, POSITION_SIZE_MAP[position], size + 'px'), babelHelpers.defineProperty(_babelHelpers$extends, position, -size + 'px'), babelHelpers.defineProperty(_babelHelpers$extends, 'transform', transform), _babelHelpers$extends)));

                return style;
            },
            maskStyle: function maskStyle() {
                var open = this.data.get('open');
                var style = (0, _css2.default)({
                    opacity: open ? 1 : 0,
                    visibility: open ? 'visible' : 'hidden'
                });
                return style;
            }
        },

        close: function close() {
            this.data.set('open', false);
        }
    });
});
//# sourceMappingURL=Drawer.js.map
