(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', '../common/util/cx', '../common/util/css', '../Button/index', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('../common/util/cx'), require('../common/util/css'), require('../Button/index'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.cx, global.css, global.index, global.babelHelpers);
        global.ExpansionPanel = mod.exports;
    }
})(this, function (exports, _san, _cx, _css, _index, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _san2 = babelHelpers.interopRequireDefault(_san);

    var _css2 = babelHelpers.interopRequireDefault(_css);

    var cx = (0, _cx.create)('expansion-panel');

    var ExpansionPanel = function (_san$Component) {
        babelHelpers.inherits(ExpansionPanel, _san$Component);

        function ExpansionPanel() {
            babelHelpers.classCallCheck(this, ExpansionPanel);
            return babelHelpers.possibleConstructorReturn(this, (ExpansionPanel.__proto__ || Object.getPrototypeOf(ExpansionPanel)).apply(this, arguments));
        }

        babelHelpers.createClass(ExpansionPanel, [{
            key: 'initData',
            value: function initData() {
                return {
                    open: false,
                    icon: 'keyboard_arrow_down',
                    title: '',
                    description: ''
                };
            }
        }, {
            key: 'toggle',
            value: function toggle() {
                this.data.set('open', !this.data.get('open'));
            }
        }]);
        return ExpansionPanel;
    }(_san2.default.Component);

    ExpansionPanel.template = '\n        <div class="{{computedClassName}}">\n            <div class="' + cx.getPartClassName('header') + '">\n                <div class="' + cx.getPartClassName('title') + '">\n                    <slot name="title">{{title}}</slot>\n                </div>\n                <div class="' + cx.getPartClassName('description') + '">\n                    <slot name="description">{{description}}</slot>\n                </div>\n                <san-icon-button\n                    style="{{iconStyle}}"\n                    on-click="toggle">\n                    {{icon}}\n                </san-icon-button>\n            </div>\n            <div class="' + cx.getPartClassName('content') + '" style="{{contentStyle}}">\n                <slot />\n            </div>\n        </div>\n    ';
    ExpansionPanel.components = {
        'san-icon-button': _index.IconButton
    };
    ExpansionPanel.computed = {
        computedClassName: function computedClassName() {
            var open = this.data.get('open');
            return cx(this).addStates({ open: open }).build();
        },
        contentStyle: function contentStyle() {
            var open = this.data.get('open');
            var style = (0, _css2.default)({
                transform: 'scaleY(' + (open ? 1 : 0) + ')',
                overflowY: open ? 'auto' : 'hidden',
                maxHeight: open ? 'auto' : '0px',
                opacity: open ? 1 : 0
            });
            return style;
        },
        iconStyle: function iconStyle() {
            var open = this.data.get('open');
            return (0, _css2.default)({
                transform: 'rotate(' + (open ? 180 : 0) + 'deg)'
            });
        }
    };
    ExpansionPanel.dataTypes = {
        open: _san.DataTypes.bool,
        icon: _san.DataTypes.string,
        title: _san.DataTypes.string,
        description: _san.DataTypes.string
    };
    exports.default = ExpansionPanel;
});
//# sourceMappingURL=ExpansionPanel.js.map
