(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', '../common/util/cx', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('../common/util/cx'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.cx, global.babelHelpers);
        global.Col = mod.exports;
    }
})(this, function (exports, _san, _cx, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });


    var cx = (0, _cx.create)('col');
    var SUPPORT_PROPS = ['span', 'order', 'offset', 'pull', 'push'];
    var SUPPORT_SCREENS = ['xs', 'sm', 'md', 'lg'];

    var Col = function (_Component) {
        babelHelpers.inherits(Col, _Component);

        function Col() {
            babelHelpers.classCallCheck(this, Col);
            return babelHelpers.possibleConstructorReturn(this, (Col.__proto__ || Object.getPrototypeOf(Col)).apply(this, arguments));
        }

        babelHelpers.createClass(Col, [{
            key: 'getColStyle',
            value: function getColStyle() {
                var gutter = +this.parent.parent.data.get('gutter');
                if (gutter) {
                    gutter = gutter / 2;
                    return {
                        'padding-left': gutter + 'px',
                        'padding-right': gutter + 'px'
                    };
                }

                return {};
            }
        }, {
            key: 'initData',
            value: function initData() {
                return {
                    colStyle: {}

                };
            }
        }, {
            key: 'attached',
            value: function attached() {
                this.data.set('colStyle', this.getColStyle());
            }
        }]);
        return Col;
    }(_san.Component);

    Col.template = '\n        <div class="{{styleClass}}" style="{{colStyle}}">\n            <slot></slot>\n        </div>\n    ';
    Col.computed = {
        styleClass: function styleClass() {
            var result = [cx(this).build()];

            var data = this.data;
            SUPPORT_PROPS.forEach(function (key) {
                var value = data.get(key);
                if (value) {
                    result.push(cx.getPartClassName(key + '-' + value));
                }
            });

            var numRegex = /^\d{1,2}$/;
            SUPPORT_SCREENS.forEach(function (screen) {
                var value = data.get(screen);
                if (!value) {
                    return;
                }

                if (numRegex.test(value)) {
                    result.push(cx.getPartClassName(screen + '-span-' + value));
                } else {
                    value = JSON.parse(value);
                    for (var i = 0, len = SUPPORT_PROPS.length; i < len; i++) {
                        var key = SUPPORT_PROPS[i];
                        var propValue = value[key];
                        if (propValue) {
                            result.push(cx.getPartClassName(screen + '-' + key + '-' + propValue));
                        }
                    }
                }
            });

            return result.join(' ');
        }
    };
    Col.dataTypes = {
        span: _san.DataTypes.oneOfType([_san.DataTypes.string, _san.DataTypes.number]),
        order: _san.DataTypes.oneOfType([_san.DataTypes.string, _san.DataTypes.number]),
        offset: _san.DataTypes.oneOfType([_san.DataTypes.string, _san.DataTypes.number]),
        push: _san.DataTypes.oneOfType([_san.DataTypes.string, _san.DataTypes.number]),
        pull: _san.DataTypes.oneOfType([_san.DataTypes.string, _san.DataTypes.number]),
        xs: _san.DataTypes.oneOfType([_san.DataTypes.number, _san.DataTypes.object]),
        sm: _san.DataTypes.oneOfType([_san.DataTypes.number, _san.DataTypes.object]),
        md: _san.DataTypes.oneOfType([_san.DataTypes.number, _san.DataTypes.object]),
        lg: _san.DataTypes.oneOfType([_san.DataTypes.number, _san.DataTypes.object])
    };
    exports.default = Col;
});
//# sourceMappingURL=Col.js.map
