(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', '../common/util/cx', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('../common/util/cx'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.cx, global.babelHelpers);
        global.Row = mod.exports;
    }
})(this, function (exports, _san, _cx, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });


    var cx = (0, _cx.create)('row');

    var Row = function (_Component) {
        babelHelpers.inherits(Row, _Component);

        function Row() {
            babelHelpers.classCallCheck(this, Row);
            return babelHelpers.possibleConstructorReturn(this, (Row.__proto__ || Object.getPrototypeOf(Row)).apply(this, arguments));
        }

        babelHelpers.createClass(Row, [{
            key: 'initData',
            value: function initData() {
                return {
                    type: 'normal',

                    gutter: 0
                };
            }
        }]);
        return Row;
    }(_san.Component);

    Row.template = '\n        <div class="{{styleClass}}" style="{{rowStyle}}">\n            <slot></slot>\n        </div>\n    ';
    Row.computed = {
        styleClass: function styleClass() {
            var result = [cx(this).build()];

            var type = this.data.get('type');
            if (type === 'flex') {
                result.push(cx.getPartClassName(type));

                var align = this.data.get('align');
                if (align) {
                    result.push(cx.getPartClassName(type + '-' + align));
                }

                var justify = this.data.get('justify');
                if (justify) {
                    result.push(cx.getPartClassName(type + '-' + justify));
                }
            }

            if (this.data.get('gutter')) {
                result.push(cx.getPartClassName('gutter'));
            }

            return result.join(' ');
        },
        rowStyle: function rowStyle() {
            var gutter = +this.data.get('gutter');
            if (gutter) {
                gutter = gutter / -2;
                return {
                    'margin-left': gutter + 'px',
                    'margin-right': gutter + 'px'
                };
            }

            return {};
        }
    };
    Row.dataTypes = {
        type: _san.DataTypes.oneOf(['normal', 'flex']),
        align: _san.DataTypes.oneOf(['top', 'middle', 'bottom']),
        gutter: _san.DataTypes.number,
        justify: _san.DataTypes.oneOf(['start', 'end', 'center', 'space-around', 'space-between'])
    };
    exports.default = Row;
});
//# sourceMappingURL=Row.js.map
