(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.babelHelpers);
        global.Icon = mod.exports;
    }
})(this, function (exports, _san, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _san2 = babelHelpers.interopRequireDefault(_san);

    exports.default = _san2.default.defineComponent({
        template: '\n        <i class="sm-icon" style="{{size ? \'font-size:\' + size + \'px\' : \'\'}}">\n            <slot />\n        </i>\n    ',
        initData: function initData() {
            return {
                size: 24
            };
        },

        dataTypes: {
            size: _san.DataTypes.oneOfType([_san.DataTypes.string, _san.DataTypes.number])
        }
    });
});
//# sourceMappingURL=Icon.js.map
