(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', '../common/util/cx', '../Button/index', '../Icon/index', '../TextField/index', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('../common/util/cx'), require('../Button/index'), require('../Icon/index'), require('../TextField/index'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.cx, global.index, global.index, global.index, global.babelHelpers);
        global.InputNumber = mod.exports;
    }
})(this, function (exports, _san, _cx, _index, _index2, _index4, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _san2 = babelHelpers.interopRequireDefault(_san);

    var _index3 = babelHelpers.interopRequireDefault(_index2);

    var _index5 = babelHelpers.interopRequireDefault(_index4);

    var cx = (0, _cx.create)('inputNumber');

    function getDecreaseResult(val, step, power) {
        var powerValue = Math.pow(10, power);
        var countValue = (powerValue * val - powerValue * step) / powerValue;
        return numConvert(countValue, power);
    }

    function getIncreaseResult(val, step, power) {
        var powerValue = Math.pow(10, power);
        var countValue = (powerValue * val + powerValue * step) / powerValue;
        return numConvert(countValue, power);
    }

    function numConvert(num, power) {
        return parseFloat(Number(num).toFixed(power));
    }

    function getPower(value) {
        var valueStr = value.toString();
        var valueIndex = valueStr.indexOf('.');
        var power = 0;
        if (valueIndex !== -1) {
            power = valueStr.length - valueIndex - 1;
        }
        return power;
    }

    var InputNumber = function (_san$Component) {
        babelHelpers.inherits(InputNumber, _san$Component);

        function InputNumber() {
            babelHelpers.classCallCheck(this, InputNumber);
            return babelHelpers.possibleConstructorReturn(this, (InputNumber.__proto__ || Object.getPrototypeOf(InputNumber)).apply(this, arguments));
        }

        babelHelpers.createClass(InputNumber, [{
            key: 'initData',
            value: function initData() {
                return {
                    plusIcon: 'add',
                    minusIcon: 'remove',
                    disabled: false,
                    value: '0',
                    max: Number.MAX_VALUE,
                    min: -Number.MAX_VALUE,
                    size: 'normal',
                    step: 1,
                    preVal: ''

                };
            }
        }, {
            key: 'attached',
            value: function attached() {
                this.data.set('preVal', this.data.get('value'));
                this.watch('value', function (value) {
                    var newVal = Number(value);
                    if (isNaN(newVal)) {
                        return;
                    }
                    var max = this.data.get('max');
                    var min = this.data.get('min');
                    if (newVal >= max) {
                        newVal = max;
                    }
                    if (newVal <= min) {
                        newVal = min;
                    }

                    if (this.data.get('preVal') === newVal) {
                        return;
                    }
                });
            }
        }, {
            key: 'enterDebounceKeyup',
            value: function enterDebounceKeyup(e) {
                var _this2 = this;

                if (this.enterTimer) {
                    clearTimeout(this.enterTimer);
                }

                this.enterTimer = setTimeout(function () {

                    var newVal = _this2.compareValue(e.target.value);
                    _this2.data.set('value', newVal.toString());
                    if (_this2.data.get('preVal') !== newVal) {

                        _this2.data.set('preVal', newVal);
                        _this2.fire('change', newVal);
                    }
                }, 500);
            }
        }, {
            key: 'setCurrentValue',
            value: function setCurrentValue(value) {
                this.data.set('preVal', +this.data.get('value'));
                var preVal = +this.data.get('preVal');
                var newVal = this.compareValue(value);
                if (preVal === newVal) {
                    return;
                }
                this.data.set('value', newVal.toString());

                this.data.set('preVal', newVal);
                this.fire('change', newVal);
            }
        }, {
            key: 'compareValue',
            value: function compareValue(value) {
                var newVal = Number(value);
                var currentMin = this.data.get('min');
                if (isNaN(newVal)) {
                    return currentMin !== -Number.MAX_VALUE ? currentMin : 0;
                }
                var max = this.data.get('max');
                var min = this.data.get('min');
                if (newVal >= max) {
                    newVal = max;
                }
                if (newVal <= min) {
                    newVal = min;
                }
                return newVal;
            }
        }, {
            key: 'decrease',
            value: function decrease() {
                if (this.data.get('disabled') || this.data.get('minDisabled')) {
                    return;
                }
                var value = this.data.get('value') || 0;
                var newVal = getDecreaseResult(+value, this.data.get('step'), this.data.get('power'));
                if (newVal < this.data.get('min')) {
                    return;
                }
                this.setCurrentValue(newVal);
            }
        }, {
            key: 'increase',
            value: function increase() {
                if (this.data.get('disabled') || this.data.get('maxDisabled')) {
                    return;
                }
                var value = this.data.get('value') || 0;
                var newVal = getIncreaseResult(+value, this.data.get('step'), this.data.get('power'));
                if (newVal > this.data.get('max')) {
                    return;
                }
                this.setCurrentValue(newVal);
            }
        }, {
            key: 'detached',
            value: function detached() {

                if (this.enterTimer) {
                    clearTimeout(this.enterTimer);
                }
            }
        }]);
        return InputNumber;
    }(_san2.default.Component);

    InputNumber.template = '\n        <div\n            class="{{computedClassName}}\n            {{size ? computedClassName + \'-\' + size : \'\'}}\n            {{disabled ? \'' + cx.getPartClassName('disabled') + '\' : \'\'}}"\n            disabled="{{disabled}}">\n            <san-text-field\n                variants="' + cx.getPartClassName('input') + '"\n                inputValue="{=value=}"\n                on-input-keyup="enterDebounceKeyup($event)"/>\n            <span\n                class="' + cx.getPartClassName('increase') + '\n                {{size ? \'' + cx.getPartClassName('increase') + '\' + \'-\' + size : \'\'}}\n                {{maxDisabled || disabled ? \'is-disabled\' : \'\'}}"\n                on-click="increase($event)">\n                <san-icon size="{{computedSize}}">{{plusIcon}}</san-icon>\n            </span>\n            <span\n                class="' + cx.getPartClassName('decrease') + '\n                {{size ? \'' + cx.getPartClassName('decrease') + '\' + \'-\'+ size : \'\'}}\n                {{minDisabled || disabled ? \'is-disabled\' : \'\'}}"\n                on-click="decrease($event)">\n                <san-icon size="{{computedSize}}">{{minusIcon}}</san-icon>\n            </span>\n\n        </div>\n    ';
    InputNumber.components = {
        'san-button': _index.Button,
        'san-text-field': _index5.default,
        'san-icon': _index3.default
    };
    InputNumber.computed = {
        computedClassName: function computedClassName() {
            return cx(this).build();
        },
        computedSize: function computedSize() {
            if (this.data.get('size') === 'large') {
                return 42;
            } else if (this.data.get('size') === 'small') {
                return 30;
            }
            return 34;
        },
        minDisabled: function minDisabled() {
            return getDecreaseResult(this.data.get('value'), this.data.get('step'), this.data.get('power')) < this.data.get('min');
        },
        maxDisabled: function maxDisabled() {
            return getIncreaseResult(this.data.get('value'), this.data.get('step'), this.data.get('power')) > this.data.get('max');
        },
        power: function power() {
            return Math.max(getPower(this.data.get('value')), getPower(this.data.get('step')));
        }
    };
    InputNumber.dataTypes = {
        plusIcon: _san.DataTypes.string,
        minusIcon: _san.DataTypes.string,
        disabled: _san.DataTypes.bool,
        value: _san.DataTypes.string,
        max: _san.DataTypes.number,
        min: _san.DataTypes.number,
        size: _san.DataTypes.oneOf(['small', 'normal', 'large']),
        step: _san.DataTypes.number
    };
    exports.default = InputNumber;
});
//# sourceMappingURL=InputNumber.js.map
