(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', '../common/util/cx', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('../common/util/cx'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.cx, global.babelHelpers);
        global.List = mod.exports;
    }
})(this, function (exports, _san, _cx, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _san2 = babelHelpers.interopRequireDefault(_san);

    var cx = (0, _cx.create)('list');
    exports.default = _san2.default.defineComponent({

        template: '\n        <div class="{{computedClassName}}">\n            <slot></slot>\n        </div>\n    ',

        inited: function inited() {
            var selectable = this.data.get('selectable');
            this.data.set('selectable', selectable === 'false' ? false : !!selectable);

            this.items = [];
        },
        attached: function attached() {
            this.watch('value', function (value) {
                this.setSelectValue(value);
                this.fire('change', value);
            });
        },


        computed: {
            computedClassName: function computedClassName() {
                return cx(this).build();
            }
        },
        messages: {
            'UI:list-item-attached': function UIListItemAttached(arg) {
                if (!this.data.get('selectable')) {
                    return;
                }
                this.items.push(arg.target);
                arg.target.data.set('selectValue', this.data.get('value'));
            },
            'UI:list-item-selected': function UIListItemSelected(arg) {
                if (!this.data.get('selectable')) {
                    return;
                }

                var newSelectValue = arg.target.data.get('value');

                this.data.set('value', newSelectValue);

                this.setSelectValue(newSelectValue);
            }
        },
        setSelectValue: function setSelectValue(value) {
            var len = this.items.length;
            while (len--) {
                this.items[len].data.set('selectValue', value);
            }
        }
    });
});
//# sourceMappingURL=List.js.map
