(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', '../Ripple/index', '../Icon/index', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('../Ripple/index'), require('../Icon/index'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.index, global.index, global.babelHelpers);
        global.ListItem = mod.exports;
    }
})(this, function (exports, _san, _index, _index2, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _san2 = babelHelpers.interopRequireDefault(_san);

    var _index3 = babelHelpers.interopRequireDefault(_index2);

    exports.default = _san2.default.defineComponent({

        template: '\n        <div\n            class="sm-list-item {{listItemClass}}"\n            on-click="toggleList($event)"\n            style="{{listItemStyle}}">\n            <div class="sm-list-item-content" style="{{itemContentStyle}}">\n                <div class="sm-list-item-left">\n                    <slot name="left" />\n                </div>\n                <p\n                    san-if="primaryText"\n                    class="sm-list-item-primary-text">\n                    {{primaryText}}\n                </p>\n                <p class="sm-list-item-secondary-text"\n                    style="{{secondaryTextStyle}}"\n                    san-if="secondaryText">\n                    {{secondaryText | raw}}\n                </p>\n            </div>\n            <san-touch-ripple san-if="!disableRipple && !disabled" />\n            <div\n                class="sm-list-item-right"\n                san-if="!toggleNested">\n                <slot name="right"></slot>\n            </div>\n            <div class="sm-list-item-expand"\n                san-if="toggleNested"\n                on-click="toggleList($event, \'EXPAND\')">\n                <san-icon>expand_{{open | listOpenIcon}}</san-icon>\n                <san-center-ripple />\n            </div>\n            <div\n                class="sm-list-item-nested {{open | listOpen}}"\n                style="{{nestedListStyle}}">\n                <slot name="nested"></slot>\n            </div>\n\n        </div>\n    ',

        components: {
            'san-touch-ripple': _index.TouchRipple,
            'san-center-ripple': _index.CenterRipple,
            'san-icon': _index3.default
        },

        messages: {
            'UI:nested-counter': function UINestedCounter(arg) {
                var target = arg.value;
                target.set('nestedLevel', target.get('nestedLevel') + 1);
                this.dispatch('UI:nested-counter', target);
            }
        },

        initData: function initData() {
            return {
                nestedLevel: 1,
                secondaryTextLines: 1,
                toggleNested: false
            };
        },


        dataTypes: {
            open: _san.DataTypes.bool,
            disabled: _san.DataTypes.bool,
            inset: _san.DataTypes.bool,

            nestedLevel: _san.DataTypes.number,
            toggleNested: _san.DataTypes.bool,
            secondaryTextLines: _san.DataTypes.number
        },

        filters: {
            listOpenIcon: function listOpenIcon(open) {
                return open ? 'less' : 'more';
            },
            listOpen: function listOpen(open) {
                return open ? '' : 'hide';
            }
        },

        computed: {
            listItemClass: function listItemClass() {
                return (this.data.get('disabled') ? 'disabled' : '') + (this.data.get('inset') ? ' inset' : '') + (this.data.get('secondaryTextLines') > 1 ? ' three-lines' : '') + (this.data.get('selectValue') && this.data.get('selectValue') === this.data.get('value') ? ' selected' : '');
            },
            itemContentStyle: function itemContentStyle() {
                return {
                    'margin-left': (this.data.get('nestedLevel') - 1) * 16 + 'px',
                    'padding-left': this.data.get('hasLeft') ? '72px' : '16px',
                    'padding-right': this.data.get('hasRight') ? '56px' : '16px'
                };
            },
            secondaryTextStyle: function secondaryTextStyle() {
                return {
                    '-webkit-line-clamp': this.data.get('secondaryTextLines')
                };
            }
        },

        inited: function inited() {
            this.data.set('open', this.data.get('initiallyOpen'));
            this.dispatch('UI:nested-counter', this.data);
            this.dispatch('UI:list-item-attached');
        },
        attached: function attached() {
            var hasLeft = false;
            var hasRight = false;
            var givenSlots = this.givenSlots.named;
            if (givenSlots.left) {
                hasLeft = true;
            }
            if (givenSlots.right) {
                hasRight = true;
            }

            this.data.set('hasLeft', hasLeft);
            this.data.set('hasRight', hasRight);
        },
        toggleList: function toggleList(evt, driver) {

            evt.stopPropagation();

            if (this.data.get('disabled')) {
                return;
            }

            var _data$get = this.data.get(),
                toggleNested = _data$get.toggleNested,
                primaryTogglesNestedList = _data$get.primaryTogglesNestedList,
                open = _data$get.open;

            if (!toggleNested) {
                this.dispatch('UI:list-item-selected');
                this.fire('click');
                return;
            }

            if (driver !== 'EXPAND') {
                this.dispatch('UI:list-item-selected');
                if (!primaryTogglesNestedList) {
                    return;
                }
            }

            this.data.set('open', !open);
            this.fire('nestedListToggle', !open);
        }
    });
});
//# sourceMappingURL=ListItem.js.map
