(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', '../common/util/cx', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('../common/util/cx'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.cx, global.babelHelpers);
        global.Mask = mod.exports;
    }
})(this, function (exports, _san, _cx, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.Mask = undefined;
    exports.show = show;
    exports.hide = hide;


    var cx = (0, _cx.create)('mask');

    var singleton = null;

    var Mask = exports.Mask = function (_Component) {
        babelHelpers.inherits(Mask, _Component);

        function Mask() {
            babelHelpers.classCallCheck(this, Mask);
            return babelHelpers.possibleConstructorReturn(this, (Mask.__proto__ || Object.getPrototypeOf(Mask)).apply(this, arguments));
        }

        babelHelpers.createClass(Mask, [{
            key: 'initData',
            value: function initData() {
                return {
                    open: false,
                    zIndex: 10
                };
            }
        }, {
            key: 'show',
            value: function show() {
                this.data.set('open', true);
            }
        }, {
            key: 'hide',
            value: function hide() {
                this.data.set('open', false);
            }
        }, {
            key: 'onRequestClose',
            value: function onRequestClose() {
                this.fire('close');
            }
        }]);
        return Mask;
    }(_san.Component);

    Mask.template = '\n        <div\n            class="{{computedClassName}}"\n            style="{{mainStyle}}"\n            on-click="onRequestClose" />\n    ';
    Mask.computed = {
        computedClassName: function computedClassName() {
            return cx(this).build();
        },
        mainStyle: function mainStyle() {
            var open = this.data.get('open');
            var zIndex = this.data.get('zIndex');
            return {
                'display': open ? 'block' : 'none',
                'z-index': zIndex
            };
        }
    };
    function show(onClose) {
        if (!singleton) {
            singleton = new Mask();
            singleton.attach(document.body);
        }
        singleton.show();
        onClose && singleton.on('close', onClose);
    }

    function hide(onClose) {
        if (singleton) {
            singleton.hide();
            onClose && singleton.un('close', onClose);
        }
    }
});
//# sourceMappingURL=Mask.js.map
