(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', '../Ripple/index', './Menu', '../Popover/index', '../TextField/index', '../common/util/cx', '../Icon/index', './constant', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('../Ripple/index'), require('./Menu'), require('../Popover/index'), require('../TextField/index'), require('../common/util/cx'), require('../Icon/index'), require('./constant'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.index, global.Menu, global.index, global.index, global.cx, global.index, global.constant, global.babelHelpers);
        global.DropDownMenu = mod.exports;
    }
})(this, function (exports, _san, _index, _Menu, _index2, _index4, _cx, _index6, _constant, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _Menu2 = babelHelpers.interopRequireDefault(_Menu);

    var _index3 = babelHelpers.interopRequireDefault(_index2);

    var _index5 = babelHelpers.interopRequireDefault(_index4);

    var _index7 = babelHelpers.interopRequireDefault(_index6);

    var C = babelHelpers.interopRequireWildcard(_constant);

    var _DropDownMenu$message;

    var cx = (0, _cx.create)('dropdown-menu');

    var DropDownMenu = function (_Component) {
        babelHelpers.inherits(DropDownMenu, _Component);

        function DropDownMenu() {
            babelHelpers.classCallCheck(this, DropDownMenu);
            return babelHelpers.possibleConstructorReturn(this, (DropDownMenu.__proto__ || Object.getPrototypeOf(DropDownMenu)).apply(this, arguments));
        }

        babelHelpers.createClass(DropDownMenu, [{
            key: 'initData',
            value: function initData() {
                return {
                    autoWidth: true,
                    readOnly: false,
                    disabled: false,
                    maxHeight: null,

                    open: false,

                    displayText: '',

                    getAnchor: this.getAnchor.bind(this)
                };
            }
        }, {
            key: 'inited',
            value: function inited() {
                this.items = [];
            }
        }, {
            key: 'attached',
            value: function attached() {
                var _this2 = this;

                this.watch('value', function (nextValue) {
                    var nextDisplayText = '';
                    var _iteratorNormalCompletion = true;
                    var _didIteratorError = false;
                    var _iteratorError = undefined;

                    try {
                        for (var _iterator = _this2.items[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
                            var item = _step.value;

                            var _item$data$get = item.data.get(),
                                title = _item$data$get.title,
                                label = _item$data$get.label,
                                value = _item$data$get.value;

                            if (nextValue === value) {
                                item.data.set('selected', true);
                                nextDisplayText = label || title || value;
                            } else {
                                item.data.set('selected', false);
                            }
                        }
                    } catch (err) {
                        _didIteratorError = true;
                        _iteratorError = err;
                    } finally {
                        try {
                            if (!_iteratorNormalCompletion && _iterator.return) {
                                _iterator.return();
                            }
                        } finally {
                            if (_didIteratorError) {
                                throw _iteratorError;
                            }
                        }
                    }

                    _this2.data.set('displayText', nextDisplayText);
                });
            }
        }, {
            key: 'detached',
            value: function detached() {
                this.items.length = 0;
                this.items = null;
            }
        }, {
            key: 'getAnchor',
            value: function getAnchor() {
                return this.el;
            }
        }, {
            key: 'openPopover',
            value: function openPopover() {
                var _data$get = this.data.get(),
                    readOnly = _data$get.readOnly,
                    disabled = _data$get.disabled;

                if (readOnly || disabled) {
                    return;
                }

                this.data.set('open', true);

                this.adjustMenuItemPosition();
            }
        }, {
            key: 'adjustMenuItemPosition',
            value: function adjustMenuItemPosition() {
                var value = this.data.get('value');
                var _iteratorNormalCompletion2 = true;
                var _didIteratorError2 = false;
                var _iteratorError2 = undefined;

                try {
                    for (var _iterator2 = this.items[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
                        var item = _step2.value;

                        if (item.data.get('value') === value) {
                            var _item$el$parentNode = item.el.parentNode,
                                scrollTop = _item$el$parentNode.scrollTop,
                                offsetHeight = _item$el$parentNode.offsetHeight;

                            var offsetTop = item.el.offsetTop;
                            if (scrollTop + offsetHeight < offsetTop || offsetTop < scrollTop) {
                                item.el.parentNode.scrollTop = offsetTop;
                            }
                            break;
                        }
                    }
                } catch (err) {
                    _didIteratorError2 = true;
                    _iteratorError2 = err;
                } finally {
                    try {
                        if (!_iteratorNormalCompletion2 && _iterator2.return) {
                            _iterator2.return();
                        }
                    } finally {
                        if (_didIteratorError2) {
                            throw _iteratorError2;
                        }
                    }
                }
            }
        }]);
        return DropDownMenu;
    }(_san.Component);

    DropDownMenu.template = '\n        <div\n            class="{{mainClassName}}"\n            style="{{dropDownMenuStyle}}"\n            on-click="openPopover">\n            <sm-popover\n                s-ref="popover"\n                open="{=open=}"\n                maxHeight="{{maxHeight}}"\n                useLayerForClickAway="{{!1}}"\n                anchorOrigin="tl"\n                targetOrigin="tl"\n                getAnchor="{{getAnchor}}"\n                matchAnchorWidth="{{!autoWidth}}"\n                on-open-complete="adjustMenuItemPosition">\n                <slot />\n            </sm-popover>\n            <sm-text-field\n                readOnly\n                inputValue="{{displayText}}"\n                disabled="{{disabled}}" />\n            <div class="' + cx.getPartClassName('icon') + '" fullWidth>\n                <sm-icon>arrow_drop_down</sm-icon>\n            </div>\n        </div>\n    ';
    DropDownMenu.computed = {
        mainClassName: function mainClassName() {
            return cx(this).build();
        }
    };
    DropDownMenu.components = {
        'sm-touch-ripple': _index.TouchRipple,
        'sm-menu': _Menu2.default,
        'sm-popover': _index3.default,
        'sm-text-field': _index5.default,
        'sm-icon': _index7.default
    };
    DropDownMenu.messages = (_DropDownMenu$message = {}, babelHelpers.defineProperty(_DropDownMenu$message, C.MENU_ITEM_ATTACHED, function (e) {
        this.items.push(e.target);
        var targetData = e.target.data;

        var _targetData$get = targetData.get(),
            value = _targetData$get.value,
            label = _targetData$get.label,
            title = _targetData$get.title;

        var selected = this.data.get('value') === value;
        targetData.set('type', 'option');
        targetData.set('selected', selected);

        if (selected) {
            this.data.set('displayText', label || title || value);
        }
    }), babelHelpers.defineProperty(_DropDownMenu$message, C.MENU_ITEM_OPTION_SELECTED, function (_ref) {
        var target = _ref.target;

        var _target$data$get = target.data.get(),
            value = _target$data$get.value,
            label = _target$data$get.label,
            title = _target$data$get.title;

        this.data.set('value', value);
        this.data.set('displayText', label || title || value);
        this.items.forEach(function (item) {
            if (item !== target) {
                item.data.set('selected', false);
            }
        });
        this.data.set('open', false);
        this.fire('change', value);
    }), babelHelpers.defineProperty(_DropDownMenu$message, C.MENU_ITEM_DETACHED, function (e) {
        this.items.splice(this.items.indexOf(e.target), 1);
    }), babelHelpers.defineProperty(_DropDownMenu$message, C.MENU_ITEM_CLICK, function () {
        this.data.set('open', false);
    }), _DropDownMenu$message);
    DropDownMenu.dataTypes = {
        autoWidth: _san.DataTypes.bool,
        readOnly: _san.DataTypes.bool,
        disabled: _san.DataTypes.bool,
        maxHeight: _san.DataTypes.number
    };
    exports.default = DropDownMenu;
});
//# sourceMappingURL=DropDownMenu.js.map
