(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', '../Button/IconButton', '../Paper/index', '../Popover/index', './constant', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('../Button/IconButton'), require('../Paper/index'), require('../Popover/index'), require('./constant'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.IconButton, global.index, global.index, global.constant, global.babelHelpers);
        global.IconMenu = mod.exports;
    }
})(this, function (exports, _san, _IconButton, _index, _index3, _constant, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _IconButton2 = babelHelpers.interopRequireDefault(_IconButton);

    var _index2 = babelHelpers.interopRequireDefault(_index);

    var _index4 = babelHelpers.interopRequireDefault(_index3);

    var C = babelHelpers.interopRequireWildcard(_constant);

    var IconMenu = function (_Component) {
        babelHelpers.inherits(IconMenu, _Component);

        function IconMenu() {
            babelHelpers.classCallCheck(this, IconMenu);
            return babelHelpers.possibleConstructorReturn(this, (IconMenu.__proto__ || Object.getPrototypeOf(IconMenu)).apply(this, arguments));
        }

        babelHelpers.createClass(IconMenu, [{
            key: 'initData',
            value: function initData() {
                return {
                    open: false,
                    getAnchor: this.getAnchor.bind(this),
                    anchorOrigin: 'tl',
                    targetOrigin: 'tl'
                };
            }
        }, {
            key: 'getAnchor',
            value: function getAnchor() {
                return this.el;
            }
        }, {
            key: 'togglePopover',
            value: function togglePopover() {
                this.data.set('open', !this.data.get('open'));
            }
        }]);
        return IconMenu;
    }(_san.Component);

    IconMenu.template = '\n        <div class="{{className}}">\n            <sm-popover\n                open="{=open=}"\n                maxHeight="{{maxHeight}}"\n                maxWidth="{{maxWidth}}"\n                anchorOrigin="{{anchorOrigin}}"\n                targetOrigin="{{targetOrigin}}"\n                getAnchor="{{getAnchor}}">\n                <sm-paper>\n                    <slot />\n                </sm-paper>\n            </sm-popover>\n            <sm-icon-button\n                on-click="togglePopover"\n                disabled="{{disabled}}">\n                <slot name="icon">{{icon}}</slot>\n            </sm-icon-button>\n        </div>\n    ';
    IconMenu.components = {
        'sm-icon-button': _IconButton2.default,
        'sm-popover': _index4.default,
        'sm-paper': _index2.default
    };
    IconMenu.messages = babelHelpers.defineProperty({}, C.MENU_ITEM_CLICK, function () {
        this.data.set('open', false);
    });
    IconMenu.dataTypes = {
        maxWidth: _san.DataTypes.number,
        maxHeight: _san.DataTypes.number,
        open: _san.DataTypes.bool,
        anchorOrigin: _index4.default.dataTypes.anchorOrigin,
        targetOrigin: _index4.default.dataTypes.targetOrigin
    };
    exports.default = IconMenu;
});
//# sourceMappingURL=IconMenu.js.map
