(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', './constant', '../common/util/cx', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('./constant'), require('../common/util/cx'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.constant, global.cx, global.babelHelpers);
        global.Menu = mod.exports;
    }
})(this, function (exports, _san, _constant, _cx, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    var C = babelHelpers.interopRequireWildcard(_constant);

    var _Menu$messages;

    var cx = (0, _cx.create)('menu');

    var Menu = function (_Component) {
        babelHelpers.inherits(Menu, _Component);

        function Menu() {
            babelHelpers.classCallCheck(this, Menu);
            return babelHelpers.possibleConstructorReturn(this, (Menu.__proto__ || Object.getPrototypeOf(Menu)).apply(this, arguments));
        }

        babelHelpers.createClass(Menu, [{
            key: 'initData',
            value: function initData() {
                return {
                    level: 0
                };
            }
        }, {
            key: 'inited',
            value: function inited() {
                this.items = [];
                this.menus = [];
                this.dispatch(C.MENU_INITED);
            }
        }, {
            key: 'attached',
            value: function attached() {
                this.updateLeftPadding();
            }
        }, {
            key: 'detached',
            value: function detached() {
                this.items.length = 0;
                this.items = null;
                this.dispatch(C.MENU_DETACH);
            }
        }, {
            key: 'updateLeftPadding',
            value: function updateLeftPadding() {
                var hasLeft = false;
                var _iteratorNormalCompletion = true;
                var _didIteratorError = false;
                var _iteratorError = undefined;

                try {
                    for (var _iterator = this.items[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
                        var item = _step.value;

                        if (item.data.get('hasLeft')) {
                            hasLeft = true;
                            break;
                        }
                    }
                } catch (err) {
                    _didIteratorError = true;
                    _iteratorError = err;
                } finally {
                    try {
                        if (!_iteratorNormalCompletion && _iterator.return) {
                            _iterator.return();
                        }
                    } finally {
                        if (_didIteratorError) {
                            throw _iteratorError;
                        }
                    }
                }

                var _iteratorNormalCompletion2 = true;
                var _didIteratorError2 = false;
                var _iteratorError2 = undefined;

                try {
                    for (var _iterator2 = this.items[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
                        var _item = _step2.value;

                        _item.data.set('hasLeft', hasLeft);
                    }
                } catch (err) {
                    _didIteratorError2 = true;
                    _iteratorError2 = err;
                } finally {
                    try {
                        if (!_iteratorNormalCompletion2 && _iterator2.return) {
                            _iterator2.return();
                        }
                    } finally {
                        if (_didIteratorError2) {
                            throw _iteratorError2;
                        }
                    }
                }
            }
        }, {
            key: 'closeAllItems',
            value: function closeAllItems() {
                this.items.forEach(function (item) {
                    if (item.data.get('subMenuOpen')) {
                        item.data.set('subMenuOpen', false);
                    }
                });
            }
        }]);
        return Menu;
    }(_san.Component);

    Menu.template = '\n        <div class="{{className}}" data-level="{{level}}">\n            <slot></slot>\n        </div>\n    ';
    Menu.computed = {
        className: function className() {
            return cx(this).build();
        }
    };
    Menu.messages = (_Menu$messages = {}, babelHelpers.defineProperty(_Menu$messages, C.MENU_ITEM_INITED, function (e) {
        var item = e.target;

        item.data.set('level', this.data.get('level'));
        this.items.push(e.target);
    }), babelHelpers.defineProperty(_Menu$messages, C.MENU_ITEM_DETACHED, function (e) {
        this.items = this.items.filter(function (item) {
            return item !== e.target;
        });
    }), babelHelpers.defineProperty(_Menu$messages, C.MENU_ITEM_EXPAND, function (e) {
        this.items.forEach(function (item) {
            if (item !== e.target) {
                item.data.set('subMenuOpen', false);
            }
        });
    }), babelHelpers.defineProperty(_Menu$messages, C.MENU_ITEM_CLICK, function (e) {
        this.items.forEach(function (item) {
            return item.data.set('subMenuOpen', false);
        });
        if (this.data.get('level') > 0) {
            this.dispatch(C.MENU_ITEM_CLICK);
        }
    }), _Menu$messages);
    exports.default = Menu;
});
//# sourceMappingURL=Menu.js.map
