(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', '../Ripple/index', '../common/util/cx', './constant', '../Popover/index', '../Paper/index', '../Icon/index', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('../Ripple/index'), require('../common/util/cx'), require('./constant'), require('../Popover/index'), require('../Paper/index'), require('../Icon/index'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.index, global.cx, global.constant, global.index, global.index, global.index, global.babelHelpers);
        global.MenuItem = mod.exports;
    }
})(this, function (exports, _san, _index, _cx, _constant, _index2, _index4, _index6, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    var C = babelHelpers.interopRequireWildcard(_constant);

    var _index3 = babelHelpers.interopRequireDefault(_index2);

    var _index5 = babelHelpers.interopRequireDefault(_index4);

    var _index7 = babelHelpers.interopRequireDefault(_index6);

    var _MenuItem$messages;

    var cx = (0, _cx.create)('menu-item');

    var CASCADE_ICON = '\n    <svg viewBox="0 0 24 24" class="' + cx.getPartClassName('cascade-icon') + '">\n        <path d="M9.5,7l5,5l-5,5V7z"></path>\n    </svg>\n';

    var MenuItem = function (_Component) {
        babelHelpers.inherits(MenuItem, _Component);

        function MenuItem() {
            babelHelpers.classCallCheck(this, MenuItem);
            return babelHelpers.possibleConstructorReturn(this, (MenuItem.__proto__ || Object.getPrototypeOf(MenuItem)).apply(this, arguments));
        }

        babelHelpers.createClass(MenuItem, [{
            key: 'initData',
            value: function initData() {
                return {
                    type: 'command',
                    disabled: false,
                    cascade: false,
                    hasLeft: false,
                    hasRight: false,
                    cascadeIcon: '',

                    popupAlignToParentMenu: false,

                    getAnchor: this.getAnchor.bind(this),

                    subMenuOpen: false

                };
            }
        }, {
            key: 'inited',
            value: function inited() {
                var _data$get = this.data.get(),
                    cascade = _data$get.cascade,
                    type = _data$get.type;

                if (type === 'checkbox' || type === 'radio') {
                    this.data.set('cascade', false);
                    this.data.set('hasLeft', false);
                } else if (cascade) {
                    this.data.set('type', 'expander');
                }

                this.dispatch(C.MENU_ITEM_INITED);
            }
        }, {
            key: 'attached',
            value: function attached() {
                var _this2 = this;

                var _data$get2 = this.data.get(),
                    type = _data$get2.type,
                    cascade = _data$get2.cascade;

                if (type !== 'checkbox' && type !== 'radio') {
                    this.data.set('hasLeft', !!(this.givenSlots && this.givenSlots.named && this.givenSlots.named.leftIcon));
                }

                this.data.set('hasRight', cascade || !!(this.givenSlots && this.givenSlots.named && this.givenSlots.named.rightIcon));

                this.watch('subMenuOpen', function (subMenuOpen) {
                    if (!subMenuOpen) {
                        _this2.subMenu.closeAllItems();
                    }
                });

                this.dispatch(C.MENU_ITEM_ATTACHED);
            }
        }, {
            key: 'detached',
            value: function detached() {
                this.dispatch(C.MENU_ITEM_DETACHED);
            }
        }, {
            key: 'getAnchor',
            value: function getAnchor() {
                return this.data.get('popupAlignToParentMenu') ? this.el.parentNode : this.el;
            }
        }, {
            key: 'click',
            value: function click(e) {
                var _data$get3 = this.data.get(),
                    type = _data$get3.type,
                    value = _data$get3.value,
                    checked = _data$get3.checked,
                    disabled = _data$get3.disabled,
                    subMenuOpen = _data$get3.subMenuOpen;

                if (disabled) {
                    e.stopPropagation();
                    e.preventDefault();
                    return;
                }

                switch (type) {

                    case 'expander':
                        {
                            this.data.set('subMenuOpen', !subMenuOpen);
                            this.dispatch(subMenuOpen ? C.MENU_ITEM_COLLAPSE : C.MENU_ITEM_EXPAND);
                            return;
                        }

                    case 'checkbox':
                        {

                            var nextChecked = ~checked.indexOf(value) ? checked.filter(function (item) {
                                return item !== value;
                            }) : [].concat(babelHelpers.toConsumableArray(checked), [value]);

                            this.data.set('checked', nextChecked);
                            this.fire('change');
                            return;
                        }

                    case 'radio':
                        {
                            if (checked !== value) {
                                this.data.set('checked', value);

                                this.dispatch(C.MENU_ITEM_RADIO_CHECKED, { value: value });

                                this.fire('change', value);
                            }

                            return;
                        }

                    case 'option':
                        {
                            this.data.set('selected', true);

                            this.dispatch(C.MENU_ITEM_OPTION_SELECTED, { value: value });

                            this.fire('change');

                            return;
                        }

                    case 'command':
                    default:
                        {
                            this.fire('click', e);
                            this.dispatch(C.MENU_ITEM_CLICK);
                            return;
                        }

                }
            }
        }]);
        return MenuItem;
    }(_san.Component);

    MenuItem.template = '\n        <div\n            class="{{mainClassName}}"\n            style="{{mainStyle}}"\n            data-value="{{value}}"\n            on-click="click($event)">\n            <sm-icon\n                s-if="type === \'checkbox\' || type === \'radio\'"\n                class="' + cx.getPartClassName('left-icon') + '">\n                {{isChecked ? \'check\' : \'\'}}\n            </sm-icon>\n            <div\n                class="' + cx.getPartClassName('left-icon') + '"\n                style="{{leftIconStyle}}">\n                <slot name="leftIcon" />\n            </div>\n            <div\n                class="' + cx.getPartClassName('content') + '"\n                style="{{titleStyle}}">\n                <div class="' + cx.getPartClassName('title') + '">{{label || title}}</div>\n                <div\n                    s-if="!!subTitle"\n                    class="' + cx.getPartClassName('sub-title') + '">\n                    {{subTitle}}\n                </div>\n            </div>\n            <div\n                class="' + cx.getPartClassName('right-icon') + '"\n                style="{{rightIconStyle}}">\n                <slot name="rightIcon">\n                    ' + CASCADE_ICON + '\n                </slot>\n            </div>\n            <sm-popover\n                s-ref="popover"\n                s-if="{{cascade}}"\n                open="{=subMenuOpen=}"\n                getAnchor="{{getAnchor}}"\n                anchorOrigin="tr"\n                offsetX="{{2}}">\n                <sm-paper>\n                    <slot name="submenu" />\n                </sm-paper>\n            </sm-popover>\n            <sm-touch-ripple s-if="!disabled"/>\n        </div>\n    ';
    MenuItem.components = {
        'sm-touch-ripple': _index.TouchRipple,
        'sm-popover': _index3.default,
        'sm-paper': _index5.default,
        'sm-icon': _index7.default
    };
    MenuItem.computed = {
        mainClassName: function mainClassName() {
            return cx(this).addVariants({
                'with-left-icon': this.data.get('hasLeft')
            }).addStates({
                selected: this.data.get('selected')
            }).build();
        },
        mainStyle: function mainStyle() {
            var hasLeft = this.data.get('hasLeft');
            var hasRight = this.data.get('hasRight');
            return hasLeft || hasRight ? { 'min-width': '10rem' } : null;
        },
        leftIconStyle: function leftIconStyle() {
            return {
                display: this.data.get('hasLeft') ? '' : 'none'
            };
        },
        rightIconStyle: function rightIconStyle() {
            var hasRight = this.data.get('hasRight');
            return {
                display: hasRight ? '' : 'none'
            };
        },
        isChecked: function isChecked() {
            var type = this.data.get('type');
            var value = this.data.get('value');
            var checked = this.data.get('checked');
            if (type === 'checkbox') {
                return checked.indexOf(value) > -1;
            }
            if (type === 'radio') {
                return checked === value;
            }
            return false;
        }
    };
    MenuItem.messages = (_MenuItem$messages = {}, babelHelpers.defineProperty(_MenuItem$messages, C.MENU_INITED, function (e) {
        var subMenu = this.subMenu = e.target;

        subMenu.data.set('level', this.data.get('level') + 1);
    }), babelHelpers.defineProperty(_MenuItem$messages, C.MENU_DETACH, function (e) {
        this.subMenu = null;
    }), _MenuItem$messages);
    MenuItem.dataTypes = {
        type: _san.DataTypes.oneOf(['command', 'checkbox', 'radio', 'expander', 'option']),
        disabled: _san.DataTypes.bool,
        cascade: _san.DataTypes.bool,
        hasLeft: _san.DataTypes.bool,
        hasRight: _san.DataTypes.bool,
        cascadeIcon: _san.DataTypes.string,
        popupAlignToParentMenu: _san.DataTypes.bool,
        label: _san.DataTypes.string,
        title: _san.DataTypes.string
    };
    exports.default = MenuItem;
});
//# sourceMappingURL=MenuItem.js.map
