(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', '../common/util/cx', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('../common/util/cx'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.cx, global.babelHelpers);
        global.Pagination = mod.exports;
    }
})(this, function (exports, _san, _cx, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });


    var cx = (0, _cx.create)('pagination');
    var currentKey = 'current';
    var pageSizeKey = 'pageSize';
    var showSizeChangerKey = 'showSizeChanger';
    var totalKey = 'total';
    var pageSizeOptionsKey = 'pageSizeOptions';
    var totalPageKey = 'totalPage';
    var pageSizePopupOpenKey = 'pageSizePopupOpen';
    var defaultPageSize = 10;
    var defaultCurrent = 1;
    var defaultPageSizeOption = [5, 10, 20, 50];
    var pageGroupLen = 5;

    var _class = function (_Component) {
        babelHelpers.inherits(_class, _Component);

        function _class() {
            babelHelpers.classCallCheck(this, _class);
            return babelHelpers.possibleConstructorReturn(this, (_class.__proto__ || Object.getPrototypeOf(_class)).apply(this, arguments));
        }

        babelHelpers.createClass(_class, [{
            key: 'initData',
            value: function initData() {
                var _ref;

                return _ref = {}, babelHelpers.defineProperty(_ref, pageSizeKey, defaultPageSize), babelHelpers.defineProperty(_ref, currentKey, defaultCurrent), babelHelpers.defineProperty(_ref, showSizeChangerKey, true), babelHelpers.defineProperty(_ref, pageSizeOptionsKey, defaultPageSizeOption), babelHelpers.defineProperty(_ref, 'pageGroupLen', pageGroupLen), _ref;
            }
        }, {
            key: 'inited',
            value: function inited() {
                var current = this.data.get(currentKey);
                var pageSizeOptions = this.data.get(pageSizeOptionsKey);
                var pageSize = this.data.get(pageSizeKey);

                if (this.data.get(showSizeChangerKey) && !pageSizeOptions.includes(pageSize)) {
                    this.setPageSize(pageSizeOptions[0]);
                }

                if (current > this.data.get(totalPageKey) || current < defaultCurrent) {
                    this.data.set(currentKey, defaultCurrent);
                }
            }
        }, {
            key: 'setPageSize',
            value: function setPageSize(pageSize) {
                if (this.data.get(pageSizeOptionsKey).includes(pageSize)) {
                    this.data.set(pageSizeKey, parseInt(pageSize, 10));
                }
            }
        }, {
            key: 'setCurrentPage',
            value: function setCurrentPage(pageNum, silence) {

                var current = parseInt(pageNum, 10);
                var totalPage = this.data.get(totalPageKey);

                if (current > totalPage) {
                    current = totalPage;
                }
                if (current < defaultCurrent) {
                    current = defaultCurrent;
                }

                if (current >= defaultCurrent && current <= totalPage && current !== this.data.get(currentKey)) {
                    this.data.set(currentKey, current);
                    if (!silence) {
                        this.fire('pageChange', {
                            pageNum: current,
                            page: current,
                            pageSize: this.data.get(pageSizeKey)
                        });
                    }
                }
            }
        }, {
            key: 'toggleSelectorPopup',
            value: function toggleSelectorPopup() {
                this.data.set(pageSizePopupOpenKey, !this.data.get(pageSizePopupOpenKey));
            }
        }, {
            key: 'changePageSize',
            value: function changePageSize(pageSize) {

                var oldPageSize = this.data.get(pageSizeKey);
                var oldCurrent = this.data.get(currentKey);
                var current = Math.ceil(((oldCurrent - 1) * oldPageSize + 1) / pageSize);

                this.setPageSize(pageSize);
                this.setCurrentPage(current, true);

                this.fire('pageSizeChange', {
                    pageNum: current,
                    page: current,
                    pageSize: pageSize
                });

                this.toggleSelectorPopup();
            }
        }]);
        return _class;
    }(_san.Component);

    _class.template = '\n        <div class="{{computedClassName}}">\n            <div class="' + cx.getPartClassName('inner') + '" san-if="total">\n                <div class="page-selector">\n                    <span class="pre-page{{ current === 1 ? \' disable\' : \'\' }}" on-click="setCurrentPage(current - 1)">\n                        <label san-if="lastPageText">{{ lastPageText }}</label>\n                        <label san-else class="pre-page-icon arrow-icon"></label>\n                    </span>\n                    <span class="page-num first-page{{ current === 1 ? \' current\' : \'\' }}" on-click="setCurrentPage(1)">1</span>\n                    <span san-if="current >= pageGroupLen" class="pre-group" on-click="setCurrentPage(current - pageGroupLen)">...</span>\n                    <span class="page-num" san-if="current - 2 >= 2 && current - 2 < totalPage" on-click="setCurrentPage(current - 2)">{{ current - 2 }}</span>\n                    <span class="page-num" san-if="current - 1 >= 2 && current - 1 < totalPage" on-click="setCurrentPage(current - 1)">{{ current - 1 }}</span>\n                    <span class="page-num current" san-if="current >= 2 && current < totalPage" on-click="setCurrentPage(current)">{{ current }}</span>\n                    <span class="page-num" san-if="current + 1 >= 2 && current + 1 < totalPage" on-click="setCurrentPage(current + 1)">{{ current + 1 }}</span>\n                    <span class="page-num" san-if="current + 2 >= 3 && current + 2 < totalPage" on-click="setCurrentPage(current + 2)">{{ current + 2 }}</span>\n                    <span san-if="totalPage - current - 1 >= pageGroupLen" class="next-group" on-click="setCurrentPage(current + pageGroupLen)">...</span>\n                    <span san-if="totalPage > 1" class="page-num last-page{{ current === totalPage ? \' current\' : \'\' }}" on-click="setCurrentPage(totalPage)">{{ totalPage }}</span>\n                    <span class="next-page{{ current === totalPage ? \' disable\' : \'\' }}" on-click="setCurrentPage(current + 1)">\n                        <label san-if="nextPageText">{{ nextPageText }}</label>\n                        <label san-else class="next-page-icon arrow-icon"></label>\n                    </span>\n                </div>\n                <div class="page-size-selector{{ pageSizePopupOpen ? \' open\' : \'\' }}" san-if="showSizeChanger">\n                    <section class="selector dropdown-selector" on-click="toggleSelectorPopup()">{{ pageSize }} / \u9875<i class="triangle"></i></section>\n                    <section class="selector-popup">\n                        <section\n                            san-for="pageSizeItem in pageSizeOptions"\n                            class="page-size-item{{ pageSizeItem === pageSize ? \' active\' : \'\' }}"\n                            on-click="changePageSize(pageSizeItem)">\n                            {{ pageSizeItem }} / \u9875\n                        </section>\n                    </section>\n                </div>\n            </div>\n        </div>\n    ';
    _class.computed = babelHelpers.defineProperty({
        computedClassName: function computedClassName() {
            return cx(this).build();
        }
    }, totalPageKey, function () {
        return Math.ceil(this.data.get(totalKey) / this.data.get(pageSizeKey)) || 0;
    });
    _class.dataTypes = {
        total: _san.DataTypes.number.isRequired,
        pageSize: _san.DataTypes.number.isRequired,
        showSizeChanger: _san.DataTypes.bool,
        pageSizeOptions: _san.DataTypes.arrayOf(_san.DataTypes.number).isRequired,
        nextPageText: _san.DataTypes.string,
        lastPageText: _san.DataTypes.string
    };
    exports.default = _class;
});
//# sourceMappingURL=Pagination.js.map
