(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', '../common/util/cx', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('../common/util/cx'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.cx, global.babelHelpers);
        global.Paper = mod.exports;
    }
})(this, function (exports, _san, _cx, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });


    var cx = (0, _cx.create)('paper');

    var Paper = function (_Component) {
        babelHelpers.inherits(Paper, _Component);

        function Paper() {
            babelHelpers.classCallCheck(this, Paper);
            return babelHelpers.possibleConstructorReturn(this, (Paper.__proto__ || Object.getPrototypeOf(Paper)).apply(this, arguments));
        }

        babelHelpers.createClass(Paper, [{
            key: 'initData',
            value: function initData() {
                return {
                    circle: false,
                    rounded: true,
                    zDepth: 1
                };
            }
        }, {
            key: 'inited',
            value: function inited() {
                this.formatParam('circle', 'rounded');
            }
        }, {
            key: 'formatParam',
            value: function formatParam() {
                var _this2 = this;

                for (var _len = arguments.length, paramName = Array(_len), _key = 0; _key < _len; _key++) {
                    paramName[_key] = arguments[_key];
                }

                paramName.forEach(function (param) {
                    var num = _this2.data.get(param);
                    num && _this2.data.set(param, !!+num);
                });
            }
        }]);
        return Paper;
    }(_san.Component);

    Paper.template = '\n        <div class="{{paperClass}}">\n            <slot></slot>\n        </div>\n    ';
    Paper.computed = {
        paperClass: function paperClass() {
            var result = [cx(this).build()];

            if (this.data.get('circle')) {
                result.push(cx.getPartClassName('circle'));
            }

            if (this.data.get('rounded')) {
                result.push(cx.getPartClassName('rounded'));
            }

            result.push(cx.getPartClassName(this.data.get('zDepth')));

            return result.join(' ');
        }
    };
    exports.default = Paper;
});
//# sourceMappingURL=Paper.js.map
