(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', '../Layer/index', '../common/util/cx', 'dom-align', 'san', '../common/util/throttle', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('../Layer/index'), require('../common/util/cx'), require('dom-align'), require('san'), require('../common/util/throttle'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.index, global.cx, global.domAlign, global.san, global.throttle, global.babelHelpers);
        global.Popover = mod.exports;
    }
})(this, function (exports, _index, _cx, _domAlign, _san, _throttle, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _index2 = babelHelpers.interopRequireDefault(_index);

    var _domAlign2 = babelHelpers.interopRequireDefault(_domAlign);

    var cx = (0, _cx.create)('popover');
    var INITIAL_POSITION_STYLE = 'top: -9999px; left: -9999px';

    var Popover = function (_Layer) {
        babelHelpers.inherits(Popover, _Layer);

        function Popover() {
            babelHelpers.classCallCheck(this, Popover);
            return babelHelpers.possibleConstructorReturn(this, (Popover.__proto__ || Object.getPrototypeOf(Popover)).apply(this, arguments));
        }

        babelHelpers.createClass(Popover, [{
            key: 'initData',
            value: function initData() {
                return {
                    open: false,

                    anchorOrigin: 'tl',

                    targetOrigin: 'tl',

                    offsetX: 0,

                    offsetY: 0,

                    maxHeight: null,

                    maxWidth: null,

                    shadow: 1,

                    closing: false

                };
            }
        }, {
            key: 'inited',
            value: function inited() {
                this.show = this.show.bind(this);
                this.hide = this.hide.bind(this);
                this.updateStatus = this.updateStatus.bind(this);
                this.transitionEnd = (0, _throttle.throttle)(this.transitionEnd.bind(this), 1000, { trailing: false });
            }
        }, {
            key: 'attached',
            value: function attached() {
                babelHelpers.get(Popover.prototype.__proto__ || Object.getPrototypeOf(Popover.prototype), 'attached', this).call(this);
                this.watch('open', this.updateStatus);
                if (this.data.get('open')) {
                    this.show();
                }
            }
        }, {
            key: 'updateStatus',
            value: function updateStatus(open) {
                this[open ? 'show' : 'hide']();
            }
        }, {
            key: 'getContent',
            value: function getContent() {
                return this.el.firstElementChild;
            }
        }, {
            key: 'show',
            value: function show() {
                var _this2 = this;

                var _data$get = this.data.get(),
                    getAnchor = _data$get.getAnchor,
                    targetOrigin = _data$get.targetOrigin,
                    anchorOrigin = _data$get.anchorOrigin,
                    offsetX = _data$get.offsetX,
                    offsetY = _data$get.offsetY,
                    matchAnchorWidth = _data$get.matchAnchorWidth,
                    maxHeight = _data$get.maxHeight,
                    maxWidth = _data$get.maxWidth;

                var anchor = typeof getAnchor === 'function' && getAnchor();

                if (!anchor) {
                    return;
                }

                var content = this.getContent();

                if (matchAnchorWidth) {
                    content.style.width = anchor.offsetWidth + 'px';
                }

                if (this.data.get('closing')) {
                    this.data.set('closing', false);
                }

                content.style.maxHeight = maxHeight == null ? 'auto' : maxHeight + 'px';
                content.style.overflowY = maxHeight == null ? 'visible' : 'auto';
                content.style.maxWidth = maxWidth == null ? 'auto' : maxWidth + 'px';
                content.style.overflowX = maxWidth == null ? 'auto' : maxWidth + 'px';

                (0, _domAlign2.default)(this.el.firstElementChild, anchor, {
                    points: [targetOrigin, anchorOrigin],
                    offset: [offsetX, offsetY],
                    overflow: {
                        adjustX: true,
                        adjustY: true
                    },
                    useCssTransform: false
                });

                setTimeout(function () {
                    if (_this2.data.get('open')) {
                        window.addEventListener('click', _this2.hide);
                    }
                }, 1);
            }
        }, {
            key: 'hide',
            value: function hide(e) {
                window.removeEventListener('click', this.hide);
                this.data.set('open', false);
                this.data.set('closing', true);
            }
        }, {
            key: 'detach',
            value: function detach() {
                window.removeEventListener('click', this.hide);
                babelHelpers.get(Popover.prototype.__proto__ || Object.getPrototypeOf(Popover.prototype), 'attached', this).call(this);
            }
        }, {
            key: 'click',
            value: function click(e) {
                e.stopPropagation();
            }
        }, {
            key: 'transitionEnd',
            value: function transitionEnd() {
                if (this.data.get('open')) {
                    this.fire('open-complete');
                    return;
                }
                this.data.set('closing', false);
                this.data.set('open', false);
                var content = this.getContent();
                content.style.top = 0;
                content.style.left = '-10000px';
                this.fire('close-complete');
            }
        }]);
        return Popover;
    }(_index2.default);

    Popover.template = '\n        <div class="{{mainClassName}}" on-click="click($event)">\n            <div\n                class="' + cx.getPartClassName('content') + '"\n                style="' + INITIAL_POSITION_STYLE + '"\n                on-transitionend="transitionEnd">\n                <slot></slot>\n            </div>\n        </div>\n    ';
    Popover.computed = {
        mainClassName: function mainClassName() {
            var closing = this.data.get('closing');
            var open = this.data.get('open');
            var shadow = this.data.get('shadow');

            var className = cx(this).addVariants(shadow && 'shadow-' + shadow).addStates({
                open: !closing && open
            }).build();

            return className;
        }
    };
    Popover.dataTypes = {
        open: _san.DataTypes.bool,
        anchorOrigin: _san.DataTypes.oneOf(['tl', 'cl', 'bl', 'tc', 'cc', 'bc', 'tr', 'cr', 'br']),
        targetOrigin: _san.DataTypes.oneOf(['tl', 'cl', 'bl', 'tc', 'cc', 'bc', 'tr', 'cr', 'br']),
        offsetX: _san.DataTypes.number,
        offsetY: _san.DataTypes.number,
        maxHeight: _san.DataTypes.number,
        maxWidth: _san.DataTypes.number,
        shadow: _san.DataTypes.number
    };
    exports.default = Popover;
});
//# sourceMappingURL=Popover.js.map
