(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', '../common/util/cx', '../common/util/css', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('../common/util/cx'), require('../common/util/css'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.cx, global.css, global.babelHelpers);
        global.LinearProgress = mod.exports;
    }
})(this, function (exports, _san, _cx, _css, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _san2 = babelHelpers.interopRequireDefault(_san);

    var _css2 = babelHelpers.interopRequireDefault(_css);

    var cx = (0, _cx.create)('linear-progress');

    exports.default = _san2.default.defineComponent({

        template: '\n        <div class="{{computedClassName}}">\n            <div class="' + cx.getPartClassName('bar') + '" style="{{barStyle}}"/>\n        </div>\n    ',

        dataTypes: {
            mode: _san.DataTypes.oneOf(['indeterminate', 'determinate']),
            value: _san.DataTypes.number,
            max: _san.DataTypes.number,
            min: _san.DataTypes.number
        },

        initData: function initData() {
            return {
                mode: 'indeterminate',
                value: 0,
                max: 100,
                min: 0
            };
        },


        computed: {
            computedClassName: function computedClassName() {
                var mode = this.data.get('mode');
                return cx(this).addVariants(mode).build();
            },
            barStyle: function barStyle() {

                var mode = this.data.get('mode');
                var value = this.data.get('value');
                var max = this.data.get('max');
                var min = this.data.get('min');

                return mode === 'determinate' ? (0, _css2.default)({
                    width: (value - min) / (max - min) * 100 + '%'
                }) : '';
            }
        }

    });
});
//# sourceMappingURL=LinearProgress.js.map
