(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'san', '../Icon/index', '../Ripple/index', 'classnames', '../babelHelpers'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('san'), require('../Icon/index'), require('../Ripple/index'), require('classnames'), require('../babelHelpers'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.san, global.index, global.index, global.classnames, global.babelHelpers);
        global.Radio = mod.exports;
    }
})(this, function (exports, _san, _index, _index3, _classnames, babelHelpers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _san2 = babelHelpers.interopRequireDefault(_san);

    var _index2 = babelHelpers.interopRequireDefault(_index);

    var _classnames2 = babelHelpers.interopRequireDefault(_classnames);

    exports.default = _san2.default.defineComponent({
        template: '\n        <label class="{{mainClass}}" on-click="handleClick($event)">\n            <input type="radio"\n                disabled="{{disabled}}"\n                name="{{name}}"\n                value="{{value}}"\n                on-change="handleChange($event)"\n                checked="{= checked =}">\n            <div class="sm-radio-wrapper">\n                <div class="sm-radio-label {{labelClass}}" san-if="label && labelLeft">{{label}}</div>\n                <div class="sm-radio-icon">\n                    <sm-center-ripple class="sm-radio-ripple-wrapper" san-ref="ripple"></sm-center-ripple>\n                    <svg\n                        class="sm-radio-icon-uncheck sm-radio-svg-icon {{iconClass}}"\n                        san-if="!checkedIcon"\n                        viewBox="0 0 24 24">\n                        <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8z"/>\n                    </svg>\n                    <svg\n                        class="sm-radio-icon-checked sm-radio-svg-icon {{iconClass}}"\n                        san-if="!uncheckIcon"\n                        viewBox="0 0 24 24">\n                        <path d="M12 7c-2.76 0-5 2.24-5 5s2.24 5 5 5 5-2.24 5-5-2.24-5-5-5zm0-5C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8z"/>\n                    </svg>\n                    <sm-icon san-if="uncheckIcon" class="sm-radio-icon-uncheck {{iconClass}}">{{uncheckIcon}}</sm-icon>\n                    <sm-icon san-if="checkedIcon" class="sm-radio-icon-checked {{iconClass}}">{{checkedIcon}}</sm-icon>\n                </div>\n                <div class="sm-radio-label {{labelClass}}" san-if="label && !labelLeft">{{label}}</div>\n            </div>\n        </label>\n    ',

        components: {
            'sm-icon': _index2.default,
            'sm-center-ripple': _index3.CenterRipple
        },
        computed: {
            mainClass: function mainClass() {
                return (0, _classnames2.default)('sm-radio', {
                    'label-left': this.data.get('labelLeft'),
                    'disabled': this.data.get('disabled'),
                    'no-label': !this.data.get('label')
                });
            }
        },
        initData: function initData() {
            return {
                name: '',
                value: '',
                label: '',
                labelLeft: false,
                labelClass: '',
                uncheckIcon: '',
                checkedIcon: '',
                iconClass: '',
                checked: ''
            };
        },

        dataTypes: {
            name: _san.DataTypes.string,
            value: _san.DataTypes.string,
            label: _san.DataTypes.string,
            labelLeft: _san.DataTypes.bool,
            labelClass: _san.DataTypes.string,
            uncheckIcon: _san.DataTypes.string,
            checkedIcon: _san.DataTypes.string,
            iconClass: _san.DataTypes.string,
            checked: _san.DataTypes.string
        },
        handleClick: function handleClick(e) {
            if (this.data.get('disabled')) {
                return;
            }

            if (e.target.tagName === 'INPUT') {
                return;
            }
            this.ref('ripple').click();
        },
        handleTouchStart: function handleTouchStart(event) {},
        handleTouchEnd: function handleTouchEnd() {},
        handleChange: function handleChange(e) {
            this.fire('change', e);
        },
        attached: function attached() {
            var _this = this;

            this.watch('checked', function (val) {
                _this.fire('input-change', val);
            });
        }
    });
});
//# sourceMappingURL=Radio.js.map
